<?php

if (!defined('PHPRPG_MAP')) define('PHPRPG_MAP', true);

require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/location.lib.php');

class MAP
{
//PUBLIC:
	var $id;
	var $name;
	var $defTile;
	var $sizeX;
	var $sizeY;
	var $sizeZ;
	var $wrapX;
	var $wrapY;
	var $wrapZ;

	var $errors;

	function load($mapId=0) {

		$mapId = intval($mapId);

		if ($mapId < 1 && $this->id < 1) return(false);
		if ($mapId < 1 && $this->id > 0) $mapId = $this->id;

		$this->flush();

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_maps";

		$sql  = "SELECT MapId,MapName,MapDefTile,MapSizeX,MapSizeY,MapSizeZ,MapWrapX,MapWrapY,MapWrapZ ";
		$sql .= "FROM $table ";
		$sql .= "WHERE MapId='$mapId'";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		list($this->id,
		     $this->name,
		     $this->defTile,
		     $this->sizeX,
		     $this->sizeY,
		     $this->sizeZ,
		     $this->wrapX,
		     $this->wrapY,
		     $this->wrapZ) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX."_maps";

		$this->errors = NULL;

		if ($this->id > 0) {

			$table02 = PHPRPG_DB_PREFIX."_map_".$this->id;

			$sql  = "UPDATE $table01 SET ";
			$sql .= "MapName='$this->name',MapDefTile='$this->defTile',";
			$sql .= "MapSizeX='$this->sizeX',MapSizeY='$this->sizeY',MapSizeZ='$this->sizeZ',";
			$sql .= "MapWrapX='$this->wrapX',MapWrapY='$this->wrapY',MapWrapZ='$this->wrapZ' ";
			$sql .= "WHERE MapId='$this->id'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			// Trim excess tiles if the map size has been limited
			if($this->sizeX > 0) {
				$sql  = "DELETE FROM $table02 WHERE LocXPos < 0 OR LocXPos >= $this->sizeX";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			}
			if($this->sizeY > 0) {
				$sql  = "DELETE FROM $table02 WHERE LocYPos < 0 OR LocYPos >= $this->sizeY";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			}
			if($this->sizeZ > 0) {
				$sql  = "DELETE FROM $table02 WHERE LocZPos < 0 OR LocZPos >= $this->sizeZ";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			}
		}
		else {

			if ($this->id < 0) $this->id = 0;

			$sql  = "INSERT INTO $table01 ";
			$sql .= "(MapDefTile,MapSizeX,MapSizeY,MapSizeZ,MapWrapX,MapWrapY,MapWrapZ,MapName)";
			$sql .= " VALUES ";
			$sql .= "('$this->defTile','$this->sizeX','$this->sizeY','$this->sizeZ','$this->wrapX','$this->wrapY','$this->wrapZ','$this->name')";

			if ($dbObj->command($sql)) {

				$this->id = mysql_insert_id();

				$sql  = "CREATE TABLE ".PHPRPG_DB_PREFIX."_map_".$this->id." (";
				$sql .= "  LocId bigint unsigned NOT NULL auto_increment,";
				$sql .= "  LocXPos int NOT NULL default '0',";
				$sql .= "  LocYPos int NOT NULL default '0',";
				$sql .= "  LocZPos int NOT NULL default '0',";
				$sql .= "  LocRegion mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocRuler mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocEvents mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocPriTile mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocAltTile mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocAltAR mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocAltHP mediumint unsigned NOT NULL default '0',";
				$sql .= "  LocLinkMapId int NOT NULL default '0',";
				$sql .= "  LocLinkMapLoc int NOT NULL default '0',";
				$sql .= "  LocLinkCost int NOT NULL default '0',";
				$sql .= "  LocTag varchar(32) NOT NULL default '',";
				$sql .= "  LocImage varchar(64) NOT NULL default '',";
				$sql .= "  PRIMARY KEY (LocId),";
				$sql .= "  UNIQUE KEY LocCords (LocXPos,LocYPos,LocZPos),";
				$sql .= "  KEY LocRegion (LocRegion),";
				$sql .= "  KEY LocRuler (LocRuler),";
				$sql .= "  KEY LocPriTile (LocPriTile),";
				$sql .= "  KEY LocAltTile (LocAltTile),";
				$sql .= "  KEY LocLink (LocLinkMapId,LocLinkMapLoc,LocLinkCost)";
				$sql .= ") TYPE=MyISAM";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

				$sql  = "CREATE TABLE ".PHPRPG_DB_PREFIX."_map_".$this->id."_attrib (";
				$sql .= "  LocAttribId bigint(20) unsigned NOT NULL auto_increment,";
				$sql .= "  LocAttribTarget bigint(20) unsigned NOT NULL default '0',";
				$sql .= "  LocAttribKey varchar(32) NOT NULL default '',";
				$sql .= "  LocAttribValue text,";
				$sql .= "  PRIMARY KEY  (LocAttribId),";
				$sql .= "  KEY LocAttribTarget (LocAttribTarget),";
				$sql .= "  KEY LocAttribKey (LocAttribKey)";
				$sql .= ") TYPE=MyISAM";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

				$sql  = "CREATE TABLE ".PHPRPG_DB_PREFIX."_map_".$this->id."_events (";
				$sql .= "  MapEventId        mediumint       unsigned NOT NULL auto_increment,";
				$sql .= "  MapEventEnter     int             unsigned NOT NULL default '0',";
				$sql .= "  MapEventLeave     int             unsigned NOT NULL default '0',";
				$sql .= "  MapEventCreate    int             unsigned NOT NULL default '0',";
				$sql .= "  MapEventDestroy   int             unsigned NOT NULL default '0',";
				$sql .= "  MapEventAttack    int             unsigned NOT NULL default '0',";
				$sql .= "  MapEventDefend    int             unsigned NOT NULL default '0',";
				$sql .= "  PRIMARY KEY      (MapEventId)";
				$sql .= ") TYPE=MyISAM";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			}
			else $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}

		// Check for limited size maps and add any missing locations if defTile is set
		if ($this->sizeX > 0 && $this->sizeY > 0 && $this->defTile > 0) {
			$sql  = 'INSERT IGNORE INTO '.PHPRPG_DB_PREFIX.'_map_'.$this->id;
			$sql .= ' (LocZPos, LocYPos, LocXPos, LocPriTile) VALUES ';
			$values = '';
			$count = 0;
			for($y=0;$y<$this->sizeY;$y++) {
				for($x=0;$x<$this->sizeX;$x++) {
					if ($values != '') $values .= ',';
					$values .= "('0','$y','$x','$this->defTile')";
					if ($count++ > 1000) {
						if(!$dbObj->command($sql.$values)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
						$values = '';
						$count = 0;
					}
				}
			}

			if ($values != '') {
				if(!$dbObj->command($sql.$values)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			}

		}

		$sql = 'OPTIMIZE TABLE '.PHPRPG_DB_PREFIX.'_map_'.$this->id;
		if(!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		if (empty($this->errors)) return(true);

		$this->delete($this->id);
		return(false);
	}

	function delete($id = 0) {

		$id = intval($id);

		if ($this->id > 0 && $id < 1) $id = $this->id;

		if ($id > 0) {
			$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$errObj = new ERROR_REPORTER();

			$this->errors = NULL;

			$table = PHPRPG_DB_PREFIX.'_maps';
			$sql = "DELETE FROM $table WHERE MapId=$id";
			if ($dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$sql = "DROP TABLE ".PHPRPG_DB_PREFIX."_map_".$id;
			if ($dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$sql = "DROP TABLE ".PHPRPG_DB_PREFIX."_map_".$id."_attrib";
			if ($dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$sql = "DROP TABLE ".PHPRPG_DB_PREFIX."_map_".$id."_events";
			if ($dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}

		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {
		$this->id = 0;
		$this->name = '';
		$this->defTile = 1;
		$this->sizeX = 1;
		$this->sizeY = 1;
		$this->sizeZ = 1;
		$this->wrapX = false;
		$this->wrapY = false;
		$this->wrapZ = false;
		$this->errors = NULL;
	}

	function getId($z, $y, $x, $mapId=0) {

		$z     = intval($z);
		$y     = intval($y);
		$z     = intval($z);
		$mapId = intval($mapId);

		if ($mapId < 1 && $this->id < 1) return(false);
		if ($mapId < 1 && $this->id > 0) $mapId = $this->id;

		$rtn = NULL;

		if ($mapId > 0) {
			$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$errObj = new ERROR_REPORTER();

			$this->errors = NULL;

			$table = PHPRPG_DB_PREFIX.'_map_'.$mapId;
			$sql = "SELECT LocId FROM $table WHERE LocXPos='$x' AND LocYPos='$y' AND LocZPos='$z' LIMIT 1";
			if ($dbObj->query($sql)) {
				if ($row = mysql_fetch_assoc($dbObj->result)) $rtn = $row['LocId'];
			}
			else $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		if (empty($this->errors)) return($rtn);
		return(false);
	}

	function getCoords($locId, $mapId=0) {

		$locId = intval($locId);
		$mapId = intval($mapId);

		if ($mapId < 1 && $this->id < 1) return(false);
		if ($mapId < 1 && $this->id > 0) $mapId = $this->id;

		$rtn = NULL;

		if ($mapId > 0) {
			$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$errObj = new ERROR_REPORTER();

			$this->errors = NULL;

			$table = PHPRPG_DB_PREFIX.'_map_'.$mapId;
			$sql = "SELECT LocXPos,LocYPos,LocZPos FROM $table WHERE LocId='$locId'";
			if ($dbObj->query($sql)) {
				if ($row = mysql_fetch_assoc($dbObj->result)) {
					$rtn['x'] = $row['LocXPos'];
					$rtn['y'] = $row['LocYPos'];
					$rtn['z'] = $row['LocZPos'];
				}
				else return(false);
			}
			else $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		if (empty($this->errors)) return($rtn);
		return(false);
	}

	function wrapCoord($n, $size) {

		$n    = intval($n);
		$size = intval($size);

		$n = ($n + $size) % $size;
		while($n < 0 && $size > 0) $n += $size;

		return($n);
	}

	function swapTiles($z, $y, $x, $swapId, $mapId=0) {

		$z      = intval($z);
		$y      = intval($y);
		$z      = intval($z);
		$swapId = intval($swapId);
		$mapId  = intval($mapId);

		if ($mapId < 1 && $this->id < 1) return(false);
		if ($mapId < 1 && $this->id > 0) $mapId = $this->id;

		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($this->id < 1) $this->load($mapId);

		if($this->sizeZ > 0 && ($z < 0 || $z >= $this->sizeZ)) {
			if ($this->wrapZ > 0) $z = $this->wrapCoord($z, $this->sizeZ);
			else $this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE, 'Location outside of map borders: Z=$z', __FILE__, __LINE__);
		}
		if($this->sizeY > 0 && ($y < 0 || $y >= $this->sizeY)) {
			if ($this->wrapY > 0) $y = $this->wrapCoord($y, $this->sizeY);
			else $this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE, 'Location outside of map borders: Y=$y', __FILE__, __LINE__);
		}
		if($this->sizeX > 0 && ($x < 0 || $x >= $this->sizeX)) {
			if ($this->wrapX > 0) $x = $this->wrapCoord($x, $this->sizeX);
			else $this->errors[] = $errObj->report(PHPRPG_ERR_NOTICE, 'Location outside of map borders: X=$x', __FILE__, __LINE__);
		}

		$locId = MAP::getId($z, $y, $x);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);

		$table = PHPRPG_DB_PREFIX.'_map_'.$this->id;

		if ($swapId > 0) {
			if ($locId < 1) {
				$sql  = "INSERT INTO $table ";
				$sql .= "(LocPriTile, LocZPos, LocYPos, LocXPos)";
				$sql .= " VALUES ";
				$sql .= "('$swapId', '$z', '$y', '$x')";
			}
			else $sql  = "UPDATE $table SET LocPriTile='$swapId' WHERE LocId='$locId'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		else if ($locId > 0) {
			$sql = "DELETE FROM $table WHERE LocId='$locId'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}

		$dbObj->flush();

		if (empty($this->errors)) return(true);
		return(false);
	}


	function snapshot($z, $y, $x, $radZ, $radY, $radX, $mapId=0) {

		$z      = intval($z);
		$y      = intval($y);
		$z      = intval($z);
		$radZ   = intval($radZ);
		$radY   = intval($radY);
		$radX   = intval($radX);
		$mapId  = intval($mapId);

		if ($mapId < 1 && $this->id < 1) return(false);
		if ($mapId < 1 && $this->id > 0) $mapId = $this->id;

		if ($this->id < 1) $this->load($mapId);

		$rtn = array();

		$min_z = $z - $radZ;
		$max_z = $z + $radZ;
		if ($this->wrapZ) {
			$min_z = $this->wrapCoord($min_z, $this->sizeZ);
			$max_z = $this->wrapCoord($max_z, $this->sizeZ);
		}
		$min_y = $y - $radY;
		$max_y = $y + $radY;
		if ($this->wrapY) {
			$min_y = $this->wrapCoord($min_y, $this->sizeY);
			$max_y = $this->wrapCoord($max_y, $this->sizeY);
		}
		$min_x = $x - $radX;
		$max_x = $x + $radX;
		if ($this->wrapX) {
			$min_x = $this->wrapCoord($min_x, $this->sizeX);
			$max_x = $this->wrapCoord($max_x, $this->sizeX);
		}

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table01 = PHPRPG_DB_PREFIX.'_map_'.$mapId;
		$table02 = PHPRPG_DB_PREFIX.'_tiles';
		$table03 = PHPRPG_DB_PREFIX.'_tile_images';

		$sql  = 'SELECT LocXPos, LocYPos, LocZPos, LocPriTile, LocAltTile, LocImage, ';
		$sql .= '	pi.TileImageId as PriId, pi.TileImagePath as PriPath, ';
		$sql .= '	ai.TileImageId as AltId, ai.TileImagePath as AltPath ';
		$sql .= "FROM $table01 ";
		$sql .= "LEFT OUTER JOIN $table02 as pt ";
		$sql .= "	ON $table01.LocPriTile = pt.TileId ";
		$sql .= "LEFT OUTER JOIN $table03 as pi ";
		$sql .= '	ON pt.TileImage = pi.TileImageId ';
		$sql .= "LEFT OUTER JOIN $table02 as at ";
		$sql .= "	ON $table01.LocAltTile = at.TileId ";
		$sql .= "LEFT OUTER JOIN $table03 as ai ";
		$sql .= '	ON at.TileImage = ai.TileImageId ';

		$cond = '';
		if ($this->sizeZ == 0 || $this->sizeZ > (2*$radZ)) {
			$cond && $cond .= 'AND ';
			$andor = ($min_z > $max_z)?'OR':'AND';
			$cond .= "(LocZPos >= '$min_z' $andor LocZPos <= '$max_z')";
		} // otherwise get all Z coords
		if ($this->sizeY == 0 || $this->sizeY > (2*$radY)) {
			$cond && $cond .= 'AND ';
			$andor = ($min_y > $max_y)?'OR':'AND';
			$cond .= "(LocYPos >= '$min_y' $andor LocYPos <= '$max_y')";
		} // otherwise get all Y coords
		if ($this->sizeX == 0 || $this->sizeX > (2*$radX)) {
			$cond && $cond .= 'AND ';
			$andor = ($min_x > $max_x)?'OR':'AND';
			$cond .= "(LocXPos >= '$min_x' $andor LocXPos <= '$max_x')";
		} // otherwise get all X coords

		$cond && $sql .= "WHERE $cond";

		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				$x = $row['LocXPos'];
				$y = $row['LocYPos'];
				$z = $row['LocZPos'];
				if (empty($row['LocAltTile'])) $rtn["$z"]["$y"]["$x"]['tile'] = $row['LocPriTile'];
				else $rtn["$z"]["$y"]["$x"]['tile'] = $row['LocAltTile'];

				if(!empty($row['LocImage'])) $rtn["$z"]["$y"]["$x"]['image'] = array($row['LocImage']);
				else $rtn["$z"]["$y"]["$x"]['image'] = array(@$row['PriPath'], @$row['AltPath']);
			}
			while($row = mysql_fetch_assoc($dbObj->result));
		}
		$dbObj->flush();

		if (empty($this->errors)) return($rtn);
		return(false);
	}


	function uniqueMaps($mapId) {

		$mapId  = intval($mapId);

		$rtn = array();

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_maps';
		$query = "SELECT MapId, MapName FROM $table ORDER BY MapName";
		if (!$dbObj->query($query)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				$id = $row['MapId'];
				$name = $row['MapName'];
				if ($id == $mapId) $selected = 'selected';
				else $selected = '';
				$rtn[] = array('selected'=>$selected, 'value'=>$id, 'display'=>$name);

			}
			while($row = mysql_fetch_assoc($dbObj->result));
		}
		$dbObj->flush();

		if (empty($this->errors)) return($rtn);
		return(false);
	}

//PRIVATE:

	function MAP($mapId=0) {
		$mapId = intval($mapId);
		$this->flush();
		if ($mapId > 0) $this->load($mapId);
	}
}


?>
