<?php

if (!defined('PHPRPG_LOCATION')) define('PHPRPG_LOCATION', true);

require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

class LOCATION
{
//PUBLIC:
	var $id;
	var $mapId;
	var $posX;
	var $posY;
	var $posZ;
	var $region;
	var $ruler;
	var $priTile;
	var $altTile;
	var $altAR;
	var $altHP;
	var $tag;
	var $image;
	var $link;

	var $errors;

	function load($locId=0, $mapId=0) {

		$locId = intval($locId);
		$mapId = intval($mapId);

		if ($locId < 1 && $this->id < 1) return(false);
		if ($locId < 1 && $this->id > 0) $locId = $this->id;
		if ($mapId < 1 && $this->mapId < 1) return(false);
		if ($mapId < 1 && $this->mapId > 0) $mapId = $this->mapId;

		$this->flush();

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_map_".$mapId;

		$sql  = "SELECT LocId,LocXPos,LocYPos,LocZPos,LocRegion,LocRuler,LocPriTile,LocAltTile,";
		$sql .= "       LocAltAR,LocAltHP,LocLinkMapId,LocLinkMapLoc,LocLinkCost,LocTag,LocImage ";
		$sql .= "FROM $table ";
		$sql .= "WHERE LocId='$locId'";
		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		list(	$this->id,
			$this->posX,
			$this->posY,
			$this->posZ,
			$this->region,
			$this->ruler,
			$this->priTile,
			$this->altTile,
			$this->altAR,
			$this->altHP,
			$this->link['map-id'],
			$this->link['loc-id'],
			$this->link['cost'],
			$this->tag,
			$this->image) = mysql_fetch_row($dbObj->result);
		$dbObj->flush();

		$this->mapId = $mapId;

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_map_".$this->mapId;

		$this->errors = NULL;

		if ($this->id > 0) {

			$sql  = "UPDATE $table SET ";
			$sql .= "LocXPos='$this->posX',LocYPos='$this->posY',LocZPos='$this->posZ',";
			$sql .= "LocRegion='$this->region',LocRuler='$this->ruler',LocPriTile='$this->priTile',";
			$sql .= "LocAltTile='$this->altTile',LocAltAR='$this->altAR',LocAltHP='$this->altHP', ";
			$sql .= "LocLinkMapId='".$this->link['map-id']."',LocLinkMapLoc='".$this->link['loc-id']."',LocLinkCost='".$this->link['cost']."', ";
			$sql .= "LocTag='$this->tag',LocImage='$this->image' ";
			$sql .= "WHERE LocId='$this->id'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		}

		if (empty($this->errors)) return(true);
		return(false);
	}

	// Should there be a delete function at all?  That should be held at map level
	function delete($locId = 0, $mapId=0) {

		$locId = intval($locId);
		$mapId = intval($mapId);

		if ($locId <= 0 && $this->id <= 0) return(false);
		if ($locId <= 0 && $this->id > 0) $locId = $this->id;
		if ($mapId <= 0 && $this->mapId <= 0) return(false);
		if ($mapId <= 0 && $this->mapId > 0) $mapId = $this->mapId;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table = PHPRPG_DB_PREFIX.'_map_'.$mapId;
		$sql = "DELETE FROM $table WHERE LocId=$locId";
		if ($dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {
		$this->id = 0;
		$this->mapId = 0;
		$this->posX = NULL;
		$this->posY = NULL;
		$this->posZ = NULL;
		$this->region = 0;
		$this->ruler = 0;
		$this->priTile = 0;
		$this->altTile = 0;
		$this->altAR= 0;
		$this->altHP = 0;
		$this->tag = '';
		$this->image = '';
		$this->link = array("map-id"=>'',"loc-id"=>'',"cost"=>'');
	}

	function getId($z, $y, $x, $mapId=0) {

		$z     = intval($z);
		$y     = intval($y);
		$z     = intval($z);
		$mapId = intval($mapId);

		if ($mapId < 1 && @$this->mapId < 1) return(false);
		if ($mapId < 1 && @$this->mapId > 0) $mapId = $this->mapId;

		$rtn = NULL;

		if ($mapId > 0) {
			$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$errObj = new ERROR_REPORTER();

			$this->errors = NULL;

			$table = PHPRPG_DB_PREFIX.'_map_'.$mapId;
			$sql = "SELECT LocId FROM $table WHERE LocXPos='$x' AND LocYPos='$y' AND LocZPos='$z' LIMIT 1";
			if ($dbObj->query($sql)) {
				if ($row = mysql_fetch_assoc($dbObj->result)) $rtn = $row['LocId'];
			}
			else $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		if (empty($this->errors)) return($rtn);
		return(false);
	}

//PRIVATE:

	function LOCATION($locId=0, $mapId=0) {
		$locId = intval($locId);
		$mapId = intval($mapId);
		$this->flush();
		if ($locId > 0 && $mapId > 0) $this->load($locId, $mapId);
	}
}


?>
