<?php
// Do standard require_onces
require_once('../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login('PHPRPG_AUTH_SCRIPT');

?>
var iScript = 0;
function setScript(iScriptId) { iScript = iScriptId; }

var iDataState = 0;
function changeForm() { iDataState = 1; }
function resetForm() { iDataState = 0; }

function checkForm(iNeedId) {
	if (iDataState) {
		if (!confirm('Are you sure? You could lose any unsaved data!')) return(false);
	}
	else {
		if (iScript <= 0 && iNeedId) {
			alert("Please select a script!");
			return(false);
		}
	}
	return(true);
}

function doPopup(url,name,x,y,bars) {
	var winArgs = 'menubar=0,toolbar=0,resizable=1,statusbar=0,scrollbars='+bars+',width='+x+',height='+y;
	childWindow = window.open(url,name,winArgs);
}

function clearScript() {
	setScript(-1);
	resetForm();
	oScriptNameInput = document.getElementById('script-name-input');
	oScriptNameInput.value = "";
	oScriptTypeSelect = document.getElementById('script-type-select');
	oScriptTypeSelect.selectedIndex = 0;
	oScriptTargetedCheckbox = document.getElementById('script-targeted-checkbox');
	oScriptTargetedCheckbox.checked = false;
	oScriptContent = document.getElementById('script-textarea');
	oScriptContent.value = '';
}

function saveScript(saveAs) {

	oScriptNameInput = document.getElementById('script-name-input');
	if (oScriptNameInput) sScriptName = oScriptNameInput.value;

	oScriptTypeSelect = document.getElementById('script-type-select');
	if (oScriptTypeSelect) iScriptType = oScriptTypeSelect.options[oScriptTypeSelect.selectedIndex].value;

	oScriptTargetedCheckbox = document.getElementById('script-targeted-checkbox');
	if (oScriptTargetedCheckbox.checked) iScriptTargeted = 1;
	else iScriptTargeted = 0;

	oScriptContent = document.getElementById('script-textarea');
	if (oScriptContent) sScriptContent = oScriptContent.value;

	if (saveAs) iSaveAs = 1;
	else iSaveAs = 0;

	args  = "?script-name="+sScriptName+"&script-type="+iScriptType;
	args += "&script-targeted="+iScriptTargeted+"&script-content="+encodeURIComponent(sScriptContent);
	args += "&script-id="+iScript+"&script-save-as="+iSaveAs;

	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/script/save-script.js.php"+args);
}

function deleteScript() {
	if (checkForm(true) && !confirm("Do you want to delete this script and all references in the game universe?")) {
		return(false);
	}
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/script/delete-script.js.php?script-id="+iScript);
}

function searchScripts() {
	oScriptSearch = document.getElementById("script-search-input");
	if (checkForm()) {
		doPopup('<?php echo PHPRPG_URL ?>/scripts.php?submit=Search&query-string='+oScriptSearch.value,'Script_Search',500,350,1);
	}
}

function loadPage() {
	loadScript("<?php echo PHPRPG_URL ?>/bin/admin/script/load-script.js.php?script-id="+iScript);
}

window.onload = function() { loadPage(); }