<?php

require_once('../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
$trans_img_url = PHPRPG_URL.'/share/images/mask_trans.png';

$objAuth = new AUTHENTICATE();
if ($objAuth->levelCheck(PHPRPG_AUTH_MAP)) {
	$admin = intval(@$_REQUEST['admin']);
} else {
	$admin = 0;
}
?>
<?php if ($admin > 0) { ?>
	var mapWidth = <?php echo PHPRPG_EDIT_WIDTH;?>;
	var mapHeight = <?php echo PHPRPG_EDIT_HEIGHT;?>;
<?php } else { ?>
	var mapWidth = <?php echo PHPRPG_NAV_RADIUS;?>;
	var mapHeight = <?php echo PHPRPG_NAV_RADIUS;?>;
<?php } ?>

var iSelectedTile = -1;

window.onload = function() {
	loadMap();
	if (oSelect = document.getElementById("palette-select")) showTiles(oSelect);
	if (oTab = document.getElementById("tool-tab-map")) selectTool(oTab);
}

function move(x,y,z) {
	<?php if ($admin > 0) { ?>
		loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/admin-move.js.php?x="+x+"&y="+y+"&z="+z);
	<?php } else { ?>
		loadScript("<?php echo PHPRPG_URL;?>/bin/move.js.php?x="+x+"&y="+y+"&z="+z);
	<?php } ?>
}

function refreshMap() {
	<?php if ($admin > 0) { ?>
		target = "/bin/admin/map/admin-refresh-locs.js.php";
	<?php } else { ?>
		target = "/bin/admin/map/refresh-locs.js.php";
	<?php } ?>
	loadScript("<?php echo PHPRPG_URL;?>"+target);
}

function updateLoc(x, y, priImage, altImage, maskImage) {
	maskTruePath = '/share/images/mask_success.png';
	if (oCell = document.getElementById(x+"|"+y)) {
		if (oImage = oCell.getElementsByTagName("IMG")[0])
			oImage.src = "<?php echo PHPRPG_URL;?>"+priImage;
		if (oImage = oCell.getElementsByTagName("IMG")[1])
			oImage.src = "<?php echo PHPRPG_URL;?>"+altImage;
		if (oImage = oCell.getElementsByTagName("IMG")[2])
			oImage.src = "<?php echo PHPRPG_URL;?>"+maskImage
		//if(oLink = oCell.getElementsByTagName("A")[0]) {
		//	if(maskImage == maskTruePath) oLink.href = "javascript:move("+x+","+y+",0);";
		//	else oLink.href = "javascript:alert('Cannot move there');";
		//}
	}
}

function updateMap() {
	mapId = 0;
	oMapSelect = document.getElementById("map-select");
	if (oMapSelect) mapId = oMapSelect[oMapSelect.selectedIndex].value;

	if (mapId == 0) return(false);

	mapName = "";
	oMapName = document.getElementById("map-name");
	if (oMapName) mapName = oMapName.value;

	mapDefTile = 0;
	oMapDefTile = document.getElementById("map-default-tile");
	if (oMapDefTile) mapDefTile = oMapDefTile.value;

	mapSizeX = 0;
	oMapSizeX = document.getElementById("map-size-x");
	if (oMapSizeX) mapSizeX = oMapSizeX.value;

	mapSizeY = 0;
	oMapSizeY = document.getElementById("map-size-y");
	if (oMapSizeY) mapSizeY = oMapSizeY.value;

	mapSizeZ = 0;
	oMapSizeZ = document.getElementById("map-size-z");
	if (oMapSizeZ) mapSizeZ = oMapSizeZ.value;

	mapWrapX = 0;
	oMapWrapX = document.getElementById("map-wrap-x");
	if (oMapWrapX) mapWrapX = oMapWrapX.checked;

	mapWrapY = 0;
	oMapWrapY = document.getElementById("map-wrap-y");
	if (oMapWrapY) mapWrapY = oMapWrapY.checked;

	mapWrapZ = 0;
	oMapWrapZ = document.getElementById("map-wrap-z");
	if (oMapWrapZ) mapWrapZ = oMapWrapZ.checked;

	querystring = "name="+mapName+"&deftile="+mapDefTile;
	querystring = querystring+"&sizex="+mapSizeX+"&sizey="+mapSizeY+"&sizez="+mapSizeZ;
	querystring = querystring+"&wrapx="+mapWrapX+"&wrapy="+mapWrapY+"&wrapz="+mapWrapZ;
	if (mapId == -1) loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/new-map.js.php?"+querystring);
	else loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/update-map.js.php?id="+mapId+"&"+querystring);
}

function removeMapFromList(id) {
	if (oSelect = document.getElementById("map-select")) {
		aOptions = oSelect.options;
		for(i=0;i<aOptions.length;i++) {
			if(aOptions[i].value == id) {
				oSelect.removeChild(aOptions[i]);
			}
		}
	}
}

function addMapToList(id, name) {
	if (oSelect = document.getElementById("map-select")) {
		var oOption = new Option(name, id, false, false);
		oSelect.add(oOption, null);
		oSelect.selectedIndex = oSelect.options.length-1;
		loadMap();
	}
}

function loadMap() {
	<?php if ($admin > 0) { ?>
		if (oSelect = document.getElementById("map-select")) { // Map Editor - listen to the select box
			target = "/bin/admin/map/admin-load-map.js.php?id="+oSelect.options[oSelect.selectedIndex].value;
		} else {
			target = "/bin/admin/map/load-map.js.php";
		}
	<?php } else { ?>
		target = "/bin/admin/map/load-map.js.php";
	<?php } ?>
	loadScript("<?php echo PHPRPG_URL;?>"+target);
}

function showMapDetails(mapName,defTileId,defTilePath,sizeX,sizeY,sizeZ,wrapX,wrapY,wrapZ) {
	if (oMapName = document.getElementById("map-name")) oMapName.value = mapName;
	if (oMapDefTile = document.getElementById("map-default-tile")) oMapDefTile.value = defTileId;
	if (oMapDefTileImg = document.getElementById("map-default-tile-img")) oMapDefTileImg.src = "<?php echo PHPRPG_URL;?>"+defTilePath;
	if (oMapSizeX = document.getElementById("map-size-x")) oMapSizeX.value = sizeX;
	if (oMapSizeY = document.getElementById("map-size-y")) oMapSizeY.value = sizeY;
	if (oMapSizeZ = document.getElementById("map-size-z")) oMapSizeZ.value = sizeZ;
	if (oMapWrapX = document.getElementById("map-wrap-x")) oMapWrapX.checked = wrapX;
	if (oMapWrapY = document.getElementById("map-wrap-y")) oMapWrapY.checked = wrapY;
	if (oMapWrapZ = document.getElementById("map-wrap-z")) oMapWrapZ.checked = wrapZ;
	if (oDisplay = document.getElementById("link-src-map"))
		oDisplay.replaceChild(document.createTextNode(mapName),oDisplay.firstChild);
}

function showTiles(oSelect) {
	terrain_id = oSelect.options[oSelect.selectedIndex].value;
	loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/load-terrain.js.php?terrain-id="+terrain_id);
}

function clearTilePalette() {
	oTerrain = document.getElementById("tile-palette");
	while (oTerrain.hasChildNodes()) oTerrain.removeChild(oTerrain.lastChild);
	iSelectedTile = -1;
}

function addTileToPalette(id, imgPath) {
	if (oTerrain = document.getElementById("tile-palette")) {
		oTile = document.createElement("img");
		oTile.setAttribute("id", "tile-"+id);
		oTile.setAttribute("name", "tile");
		oTile.setAttribute("src", "<?php echo PHPRPG_URL;?>"+imgPath);
		oTile.onclick = function(){ selectTile(id); };
		oTile.className = "unseltile";
		oTerrain.appendChild(oTile);
	}
}

function selectTile(iTile) {
	if (oPalette = document.getElementById("tile-palette")) {
		aImages = oPalette.getElementsByTagName("IMG");
		for (i=0; i<aImages.length; i++) {
			aImages[i].className = "unseltile";
		}
		iSelectedTile = iTile;
		oImage = document.getElementById("tile-"+iTile);
		oImage.className = "seltile";
	}
}

function defineDefaultTile(oImg) {
	if (iSelectedTile < 0) {
		return;
	}
	oSelectedTile = document.getElementById("tile-"+iSelectedTile);
	oMapDefTile = document.getElementById("map-default-tile");
	oMapDefTile.value = iSelectedTile;
	oImg.src = oSelectedTile.src;
}

function defineLocation(oCell) {
	switch(sToolName) {
		case "map":
			if(iSelectedTile < 0) return;
			aCoords = oCell.id.match(/(.*)\|(.*)/);
			x = aCoords[1];
			y = aCoords[2];
			loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/define-location.js.php?mapx="+x+"&mapy="+y+"&id="+iSelectedTile);
			break;
		case "link":
			aCoords = oCell.id.match(/(.*)\|(.*)/);
			x = aCoords[1];
			y = aCoords[2];
			loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/load-link.js.php?posX="+x+"&posY="+y+"&posZ=0");
			break;
	}
}

function wrapCoord(n, size) {
	n = (n + size) % size;
	while(n < 0 && size > 0) n += size;
	return n;
}

// locX and locY should be the users current coordinates as provided from the server
function rebuildMap(locX, locY, sizeX, sizeY, wrapX, wrapY) {
	oMap = document.getElementById("map-table");
	aBody = oMap.getElementsByTagName("tbody");
	if (aBody.length > 0) {
		oMap = aBody[0];
	}
	aRows = oMap.getElementsByTagName("tr");
	for(dy=-mapHeight; dy<=mapHeight; dy++) {
		oRow = aRows[(dy+mapHeight)];
		aCells = oRow.getElementsByTagName("td");
		aCells = oRow.getElementsByTagName("td");
		for(dx=-mapWidth; dx<=mapWidth; dx++) {
			coordX = locX+dx;
			coordY = locY+dy;
			if (wrapX) coordX = wrapCoord(coordX, sizeX);
			if (wrapY) coordY = wrapCoord(coordY, sizeY);
			oCell = aCells[(dx+mapWidth)];
			oCell.setAttribute("id", (coordX)+"|"+(coordY));
			oImage = oCell.getElementsByTagName("img")[0];
			oImage.setAttribute("alt", "("+(coordX)+","+(coordY)+")");
		}
	}
	refreshMap();
}

function selectTool(oTab) {
	sId = oTab.id;
	sToolName = sId.substr(9);
	oTool = document.getElementById("tool-" + sToolName);
	oToolBox = oTool.parentNode;
	for(i=0;i<oToolBox.childNodes.length;i++) {
		if(oToolBox.childNodes[i].className == "tool") {
			oToolBox.childNodes[i].style.display = "none";
		}
	}
	oTool.style.display = "block";
}

function linkPicker() {
	window.open("<?php echo PHPRPG_URL;?>/maps.php?submit=Pick%20Location", "_blank", "width=350,height=350,location=no,menubar=no,status=no,toolbar=no");
}

function setLinkDest(dstMapId,dstX,dstY,dstZ) {
	if (oSelect = document.getElementById("link-dst-map")) {
		for(i=0;i<oSelect.options.length;i++) {
			if(oSelect.options[i].value == dstMapId) {
				oSelect.selectedIndex = i;
			}
		}
	}
	if (oInput = document.getElementById("link-dst-x")) oInput.value = dstX;
	if (oInput = document.getElementById("link-dst-y")) oInput.value = dstY;
	if (oInput = document.getElementById("link-dst-z")) oInput.value = dstZ;
}

function showLinkDetails(srcX,srcY,srcZ,dstMapId,dstX,dstY,dstZ,moveCost) {
	if (oDisplay = document.getElementById("link-src-x"))
		oDisplay.replaceChild(document.createTextNode(srcX),oDisplay.firstChild);
	if (oDisplay = document.getElementById("link-src-y"))
		oDisplay.replaceChild(document.createTextNode(srcY),oDisplay.firstChild);
	if (oDisplay = document.getElementById("link-src-z"))
		oDisplay.replaceChild(document.createTextNode(srcZ),oDisplay.firstChild);
	if (oSelect = document.getElementById("link-dst-map")) {
		for(i=0;i<oSelect.options.length;i++) {
			if(oSelect.options[i].value == dstMapId) {
				oSelect.selectedIndex = i;
			}
		}
	}

	if (moveCost < 1) moveCost = '';
	if (dstY < 1) dstY = '';
	if (dstX < 1) dstX = '';
	if (dstZ < 1) dstZ = '';

	if (oInput = document.getElementById("link-dst-x")) oInput.value = dstX;
	if (oInput = document.getElementById("link-dst-y")) oInput.value = dstY;
	if (oInput = document.getElementById("link-dst-z")) oInput.value = dstZ;
	if (oInput = document.getElementById("link-cost")) oInput.value = moveCost;
}

function loadLink() {
	srcPosX = '';
	oDisplay = document.getElementById("link-src-x");
	if (oDisplay) srcPosX = oDisplay.firstChild.nodeValue;

	srcPosY = '';
	oDisplay = document.getElementById("link-src-y");
	if (oDisplay) srcPosY = oDisplay.firstChild.nodeValue;

	srcPosZ = '';
	oDisplay = document.getElementById("link-src-z");
	if (oDisplay) srcPosZ = oDisplay.firstChild.nodeValue;

	loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/load-link.js.php?posX="+srcPosX+"&posY="+srcPosY+"&posZ="+srcPosZ);
}

function updateLink() {
	srcMapId = '';
	oDisplay = document.getElementById("link-src-map");
	if (oDisplay) srcMapId = oDisplay.firstChild.nodeValue;

	srcPosX = '';
	oDisplay = document.getElementById("link-src-x");
	if (oDisplay) srcPosX = oDisplay.firstChild.nodeValue;

	srcPosY = '';
	oDisplay = document.getElementById("link-src-y");
	if (oDisplay) srcPosY = oDisplay.firstChild.nodeValue;

	srcPosZ = '';
	oDisplay = document.getElementById("link-src-z");
	if (oDisplay) srcPosZ = oDisplay.firstChild.nodeValue;

	dstMapId = '';
	oSelect = document.getElementById("link-dst-map");
	if (oSelect) dstMapId = oSelect.options[oSelect.selectedIndex].value;

	dstPosX = '';
	oInput = document.getElementById("link-dst-x");
	if (oInput) dstPosX = oInput.value;

	dstPosY = '';
	oInput = document.getElementById("link-dst-y");
	if (oInput) dstPosY = oInput.value;

	dstPosZ = '';
	oInput = document.getElementById("link-dst-z");
	if (oInput) dstPosZ = oInput.value;

	moveCost = 0;
	oInput = document.getElementById("link-cost");
	if (oInput) moveCost = oInput.value;

	querystring = "?srcMapId="+srcMapId+"&dstMapId="+dstMapId+"&moveCost="+moveCost;
	querystring = querystring+"&srcPosX="+srcPosX+"&srcPosY="+srcPosY+"&srcPosZ="+srcPosZ;
	querystring = querystring+"&dstPosX="+dstPosX+"&dstPosY="+dstPosY+"&dstPosZ="+dstPosZ;
	loadScript("<?php echo PHPRPG_URL;?>/bin/admin/map/update-link.js.php"+querystring);
}

function showMask(oLink) {
	clearMasks();
	if(oMask = oLink.getElementsByTagName("IMG")[2]) {
		oMask.style.display = "block";
	}
}

function clearMasks() {
	oMap = document.getElementById("map-table");
	if(!oMap) return;
	aBody = oMap.getElementsByTagName("tbody");
	if (aBody.length > 0) {
		oMap = aBody[0];
	}
	aCells = oMap.getElementsByTagName("TD");
	for(i=0; i<aCells.length; i++) {
		aCells[i].getElementsByTagName("IMG")[2].style.display = "none";
	}
}
