<?php

if (!defined('PHPRPG_ITEM_INFO')) define('PHPRPG_ITEM_INFO', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

class ITEM_INFO
{
//PUBLIC:

	var $id;
	var $name;
	var $size;
	var $weight;
	var $imageId;
	var $stackable;
	var $value;
	var $events;
	var $ar;
	var $hp;
	var $dmgMin;
	var $dmgMax;
	var $dmgAdj;
	var $maxCC;
	var $maxSlots;
	var $equipLoc;
	var $twoHanded;
	var $imageId;
	var $imagePath;
	var $attributes;

	function ITEM_INFO($itemId=0) {

		$this->equipLoc = -1;
		$this->attributes = array();
		if ($itemId > 0 && !$this->load($itemId)) return(false);
		return(true);
	}

	function load($itemId=0) {

		$itemId = intval($itemId);

		if ($itemId < 1 && $this->id < 1) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX."_item_info";
		$table02 = PHPRPG_DB_PREFIX."_item_images";
		$table03 = PHPRPG_DB_PREFIX."_item_events";

		$sql  = "SELECT  ItemInfoId,ItemInfoSize,ItemInfoWeight,ItemInfoValue,ItemInfoStackable,ItemInfoEvent,ItemInfoContainer,";
		$sql .= "        ItemInfoAR,ItemInfoHP,ItemInfoDmgMin,ItemInfoDmgMax,ItemInfoDmgAdj,ItemInfoMaxCC,ItemInfoMaxSlots,";
		$sql .= "        ItemInfoEquipLoc,ItemInfoTwoHanded,ItemInfoImageIcon,ItemInfoImageMerg,ItemInfoName,ItemInfoAttribs, ";
		$sql .= "        ItemEventEquip,ItemEventUnequip,ItemEventPickup,ItemEventDrop,ItemEventCreate,ItemEventDestroy,ItemEventUse ";
		$sql .= "FROM $table01 ";
		$sql .= "LEFT OUTER JOIN $table03 ";
		$sql .= "ON $table01.ItemInfoId = $table03.ItemEventId ";
		$sql .= "WHERE ItemInfoId=$itemId";

		if (!$dbObj->query($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		list($this->id,
			$this->size,
			$this->weight,
			$this->value,
			$this->stackable,
			$this->events,
			$this->craft,
			$this->ar,
			$this->hp,
			$this->dmgMin,
			$this->dmgMax,
			$this->dmgAdj,
			$this->maxCC,
			$this->maxSlots,
			$this->equipLoc,
			$this->twoHanded,
			$this->imageId['icon'],
			$this->imageId['merg'],
			$this->name,
			$this->attributes,
		    $this->event['Equip'],
		    $this->event['Unequip'],
		    $this->event['Pickup'],
		    $this->event['Drop'],
		    $this->event['Create'],
		    $this->event['Destroy'],
		    $this->event['Use']) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		$sql  = "SELECT ItemImagePath,ItemImageType FROM $table02 WHERE ";
		$sql .= "ItemImageId='".$this->imageId['icon']."' OR ";
		$sql .= "ItemImageId='".$this->imageId['merg']."'";

		if (!$dbObj->query($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				if ($row['ItemImageType'] == 1) $this->imagePath['icon'] = $row['ItemImagePath'];
				else $this->imagePath['merg'] = $row['ItemImagePath'];
			}
			while ($row = mysql_fetch_assoc($dbObj->result));
		}

		$dbObj->flush();

		return(true);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX."_item_info";
		$table02 = PHPRPG_DB_PREFIX."_item_events";

		if ($this->id > 0) {
			$sql  = "UPDATE $table01 SET ";
			$sql .= "ItemInfoName='$this->name',ItemInfoSize='$this->size',ItemInfoWeight='$this->weight',ItemInfoStackable='$this->stackable',ItemInfoImageIcon='".$this->imageId['icon']."',ItemInfoImageMerg='".$this->imageId['merg']."',";
			$sql .= "ItemInfoAR='$this->ar',ItemInfoHP='$this->hp',ItemInfoDmgMin='$this->dmgMin',ItemInfoDmgMax='$this->dmgMax',ItemInfoDmgAdj='$this->dmgAdj',";
			$sql .= "ItemInfoMaxCC='$this->maxCC',ItemInfoMaxSlots='$this->maxSlots',ItemInfoValue='$this->value',ItemInfoEquipLoc='$this->equipLoc',ItemInfoTwoHanded='$this->twoHanded' ";
			$sql .= "WHERE ItemInfoId='$this->id'";

			if (!$dbObj->command($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$sql  = "UPDATE $table02 SET ";
			$sql .= "ItemEventEquip='".$this->event['Equip']."',ItemEventUnequip='".$this->event['Unequip']."', ";
			$sql .= "ItemEventPickup='".$this->event['Pickup']."',ItemEventDrop='".$this->event['Drop']."', ";
			$sql .= "ItemEventCreate='".$this->event['Create']."',ItemEventDestroy='".$this->event['Destroy']."', ";
			$sql .= "ItemEventUse='".$this->event['Use']."' ";
			$sql .= "WHERE ItemEventId='$this->id'";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		else {
			$sql  = "INSERT INTO $table01 ";
			$sql .= "( ItemInfoName,ItemInfoSize,ItemInfoWeight,ItemInfoValue,ItemInfoStackable,ItemInfoAR,ItemInfoHP,ItemInfoDmgMin,ItemInfoDmgMax,ItemInfoDmgAdj,ItemInfoMaxCC,ItemInfoMaxSlots,ItemInfoEquipLoc,ItemInfoTwoHanded,ItemInfoImageIcon,ItemInfoImageMerg )";
			$sql .= " VALUES ";
			$sql .= "( '$this->name','$this->size','$this->weight','$this->value','$this->stackable','$this->ar','$this->hp','$this->dmgMin','$this->dmgMax','$this->dmgAdj','$this->maxCC','$this->maxSlots','$this->equipLoc','$this->twoHanded','".$this->imageId['icon']."','".$this->imageId['merg']."' )";

			if (!$dbObj->command($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$this->id = mysql_insert_id();

			$sql  = "INSERT INTO $table02 ";
			$sql .= "(ItemEventId,ItemEventEquip,ItemEventUnequip,ItemEventPickup,ItemEventDrop,ItemEventCreate,ItemEventDestroy,ItemEventUse)";
			$sql .= " VALUES ($this->id,";
			$sql .= " '".$this->event['Equip']."','".$this->event['Unequip']."',";
			$sql .= " '".$this->event['Pickup']."','".$this->event['Drop']."',";
			$sql .= " '".$this->event['Create']."','".$this->event['Destroy']."',";
			$sql .= " '".$this->event['Use']."')";

			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		return(true);
	}

	function delete($id = 0) {

		$id = intval($id);

		if ($this->id > 0 && $id == 0) $id = $this->id;

		if ($id > 0) {

			$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$errObj = new ERROR_REPORTER();

			$table = PHPRPG_DB_PREFIX.'_items';
			$sql = "DELETE FROM $table WHERE ItemInfo=$id";
			if (!$dbObj->command($sql)) return(false);

			$table = PHPRPG_DB_PREFIX.'_item_info';
			$sql = "DELETE FROM $table WHERE ItemInfoId=$id";
			if (!$dbObj->command($sql)) return(false);

			$table = PHPRPG_DB_PREFIX.'_item_events';
			$sql = "DELETE FROM $table WHERE ItemEventId=$id";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			return(true);
		}
		return(false);
	}

	function getId($itemName) {

		$itemName = trim($itemName);

		if (empty($itemName)) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_item_info';
		$query = "SELECT ItemInfoId FROM $table WHERE ItemInfoName='$itemName' LIMIT 1";
		if (!$dbObj->query($query)) exit($dbObj->error);
		else $row = mysql_fetch_assoc($dbObj->result);

		$dbObj->flush();

		return($row['ItemInfoId']);
	}

	function unique() {

		if (empty($this->name)) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_item_info';
		$query = "SELECT ItemInfoId FROM $table WHERE ItemInfoName='$this->name' LIMIT 1";
		if (!$dbObj->query($query)) exit($dbObj->error);
		$row = mysql_fetch_assoc($dbObj->result);

		$dbObj->flush();

		if (empty($row['ItemInfoId']) || $this->id == $row['ItemInfoId']) return(true);
		return(false);
	}

	// Replace old imageId of current instance with new imageId from $imageId
	function swapImage($imageId) {

		If ($imageId < 1) return(false);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($imageId > 0) {

			$table = PHPRPG_DB_PREFIX."_item_images";
			$sql  = "SELECT ItemImagePath,ItemImageType FROM $table WHERE ItemImageId=$imageId";

			if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			$row = mysql_fetch_assoc($dbObj->result);

			switch($row['ItemImageType']) {
			case 1:
				$this->imageId['icon'] = $imageId;
				$this->imagePath['icon'] = $row["ItemImagePath"];
				break;
			case 0:
				$this->imageId['merg'] = $imageId;
				$this->imagePath['merg'] = $row["ItemImagePath"];
				break;
			}
		}

		if (empty($this->errors)) return(true);
		return(false);
	}
}


?>