<?php

if (!defined('PHPRPG_ITEM')) define('PHPRPG_ITEM', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/item_info.lib.php');

class ITEM
{
//PUBLIC:

	var $id;
	var $info_id;
	var $item_info;
	var $made_by;
	var $quality;
	var $count;
	var $cursed;
	var $cur_hp;
	var $cur_ar;
	var $cur_weight;
	var $cur_slots;
	var $cur_value;
	var $loc_type;
	var $loc_id;
	var $location;

	function load($itemId=0) {

		$itemId = intval($itemId);

		if ($itemId < 1 && $this->id < 1) return(false);
		if ($itemId < 1 && $this->id > 0) $itemId = $this->id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_items";

		$sql  = "SELECT  ItemId,ItemInfo,ItemMadeBy,ItemQuality,ItemCount,ItemCursed,ItemCurHP,";
		$sql .= "        ItemCurAR,ItemCurWeight,ItemCurSlots,ItemCurValue,ItemLocType,ItemLocId,";
		$sql .= "        ItemLocation,ItemPFColour,ItemHFColour ";
		$sql .= "FROM $table ";
		$sql .= "WHERE ItemId=$itemId";

		if (!$dbObj->query($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		list($this->id,
		     $this->info_id,
		     $this->made_by,
		     $this->quality,
		     $this->count,
		     $this->cursed,
		     $this->cur_hp,
		     $this->cur_ar,
		     $this->cur_weight,
		     $this->cur_slots,
		     $this->cur_value,
		     $this->loc_type,
		     $this->loc_id,
		     $this->location,
		     $pf,
		     $hf) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		$this->pf = unserialize($pf);
		$this->hf = unserialize($hf);

		$this->item_info = new ITEM_INFO($this->info_id);

		$table = PHPRPG_DB_PREFIX.'_item_images';
		$sql = "SELECT ItemImagePath FROM $table WHERE ItemImageId=".$this->item_info->imageId['icon'];

		if (!$dbObj->query($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		list($this->icon_template) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		return(true);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX."_items";

		$pf = serialize($this->pf);
		$hf = serialize($this->hf);

		if ($this->id > 0) {
			$sql  = "UPDATE $table01 SET ";
			$sql .= "ItemInfo='$this->info_id',ItemMadeBy='$this->made_by',ItemQuality='$this->quality',ItemCount='$this->count',ItemCursed='$this->cursed',ItemCurHP='$this->cur_hp',";
			$sql .= "ItemCurAR='$this->cur_ar',ItemCurWeight='$this->cur_weight',ItemCurSlots='$this->cur_slots',ItemCurValue='$this->cur_value',ItemLocType='$this->loc_type',";
			$sql .= "ItemLocId='$this->loc_id',ItemLocation='$this->location',ItemPFColour='$pf',ItemHFColour='$hf' ";
			$sql .= "WHERE ItemId='$this->id'";

			if (!$dbObj->command($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		}
		else {
			$sql  = "INSERT INTO $table01 ";
			$sql .= "( ItemInfo,ItemMadeBy,ItemQuality,ItemCount,ItemCursed,ItemCurHP,ItemCurAR,ItemCurWeight,ItemCurSlots,ItemCurValue,ItemLocType,ItemLocId,ItemLocation,ItemPFColour,ItemHFColour )";
			$sql .= " VALUES ";
			$sql .= "( '$this->info_id','$this->made_by','$this->quality','$this->count','$this->cursed','$this->cur_hp','$this->cur_ar','$this->cur_weight','$this->cur_slots','$this->cur_value','$this->loc_type','$this->loc_id','$this->location','$pf','$hf' )";

			if (!$dbObj->command($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$this->id = mysql_insert_id();
		}
		return(true);
	}

	function delete($itemId = 0) {

		$itemId = intval($itemId);

		if ($itemId < 1 && $this->id < 1) return(false);
		if ($itemId < 1 && $this->id > 0) $itemId = $this->id;

		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_items';
		$sql = "DELETE FROM $table WHERE ItemId=$id";
		if (!$dbObj->command($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {

		$this->id            = 0;
		$this->info_id       = 0;
		$this->item_info     = 0;
		$this->made_by       = 0;
		$this->quality       = 0;
		$this->count         = 0;
		$this->cursed        = false;
		$this->cur_hp        = 0;
		$this->cur_ar        = 0;
		$this->cur_weight    = 0;
		$this->cur_slots     = 0;
		$this->cur_value     = 0;
		$this->loc_type      = 0;
		$this->loc_id        = 0;
		$this->location      = 0;
		$this->pf            = array();
		$this->hf            = array();
		$this->icon_template = 0;
		$this->errors        = NULL;
	}

	function image() {

		if (empty($this->icon_template)) {
			return(PHPRPG_URL."/share/images/x.png");
		}

		$r_pf = $this->pf[0]; $g_pf = $this->pf[1];	$b_pf = $this->pf[2];
		$r_hf = $this->hf[0]; $g_hf = $this->hf[1];	$b_hf = $this->hf[2];

		$filename = md5($this->icon_template."-pf$r_pf$g_pf$b_pf-hf$r_hf$g_hf$b_hf").".png";

		if (!file_exists(PHPRPG_TMP_DIR."/".$filename)) {

			$tmp_img  = imagecreatefrompng(PHPRPG_DIR.$this->icon_template);

			if($this->pf != "") {
				$image_pf = imagecolorexact($tmp_img, 255,255,255);
				imagecolorset($tmp_img, $image_pf, $r_pf, $g_pf, $b_pf);
			}
			if($this->hf != "") {
				$image_hf = imagecolorexact($tmp_img, 128,128,128);
				imagecolorset($tmp_img, $image_hf, $r_hf, $g_hf, $b_hf);
			}

			imagepng($tmp_img, PHPRPG_TMP_DIR."/".$filename);

		}
		return(PHPRPG_TMP_URL."/".$filename);
	}

	function exists($itemId=0) {

		$itemId = intval($itemId);

		if ($itemId < 1 && $this->id < 1) return(false);
		if ($itemId < 1 && $this->id > 0) $itemId = $this->id;

		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_items';
		$sql = "SELECT ItemId FROM $table WHERE ItemId=$itemId";

		if (!$dbObj->query($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		list($id) = mysql_fetch_row($dbObj->result);

		if (empty($this->errors) && $id > 0) return(true);
		return(false);
	}

	function existsAt($itemId=0,$locType=0,$locId=0,$location=0) {

		$itemId   = intval($itemId);
		$locType  = intval($locType);
		$locId    = intval($locId);
		$location = intval($location);

		if ($itemId < 1 && $this->id < 1) return(false);
		if ($itemId < 1 && $this->id > 0) $itemId = $this->id;
		if ($locType  < 1 && $this->loc_type > 0) $locType  = $this->loc_type;
		if ($locId    < 1 && $this->loc_id   > 0) $locId    = $this->loc_id;
		if ($location < 1 && $this->location > 0) $location = $this->location;

		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX.'_items';
		$sql = "SELECT ItemId FROM $table WHERE ItemLocType=$locType AND ItemLocId=$locId && ItemLocation=$location && ItemId=$itemId";

		if (!$dbObj->query($sql)) $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		list($id) = mysql_fetch_row($dbObj->result);

		if (empty($this->errors) && $id > 0) return(true);
		return(false);
	}

// PRIVATE:
	var $pf;
	var $hf;
	var $icon_template;
	var $errors;

	function ITEM($itemId=0) {
		$item_id = intval($itemId);
		if ($item_id > 0 && !$this->load($item_id)) return(false);
		return(true);
	}
}


?>