<?php

if (!defined('PHPRPG_ERROR_REPORTER')) define('PHPRPG_ERROR_REPORTER', true);

define('PHPRPG_ERR_ALL',      15);
define('PHPRPG_ERR_CRITICAL', 8);
define('PHPRPG_ERR_ERROR',    4);
define('PHPRPG_ERR_MINOR',    3);
define('PHPRPG_ERR_WARN',     2);
define('PHPRPG_ERR_NOTICE',   1);

class ERROR_REPORTER
{
//PUBLIC:
	// return the log as an array; as directed by a bitwise filtering sysetm use on the return from file().
	function retrieve($filter=PHPRPG_ERR_ALL) {

		if (!($file = file(PHPRPG_ERROR_FILE))) $this->report(PHPRPG_ERR_CRITICAL, "Can not access log file '$filepath'", __FILE__, __LINE__);

		$filter = intval($filter);
		$levels = array('critical'=> PHPRPG_ERR_CRITICAL,
		                'error'   => PHPRPG_ERR_ERROR,
		                'warning' => PHPRPG_ERR_WARN,
		                'notice'  => PHPRPG_ERR_NOTICE);
		$rtn = array();

		foreach ($file as $line) {
				if (preg_match('/^\[[^\]]*\] \[(\w*)\]/', $line, $matches)) {
					$match = strtolower($matches[1]);
					if ($filter&(@$levels[$match])) $rtn[] = $line;
				}
		}

		return($rtn);
	}

	// clear all entries in a log
	function clear() {
		$today = date("D M j G:i:s T Y");
		$fp = fopen(PHPRPG_ERROR_FILE, "w");
		fclose($fp);
		return($this->report(PHPRPG_ERR_NOTICE,"Log was reset"));
	}

	// report an error for log (and display	if critical)
	function report($level,$error,$page='',$line=0) {

		$level = intval($level);
		$error = trim($error);
		$lnum  = intval($line);
		$page  = trim($page);

		if (!empty($level) && !empty($error)) {

			$client = 'client '.$_SERVER['REMOTE_ADDR'];
			$date   = date("D M j G:i:s Y");

			if (!empty($page)) {
				$page = ": $page";
				if ($line > 0) $lnum = "on line $line";
			}
			else {
				$page = '';
				$lnum = '';
			}

			switch($level) {
			case PHPRPG_ERR_CRITICAL: $lvl = "critical"; break;
			case PHPRPG_ERR_ERROR:    $lvl = "error";    break;
			case PHPRPG_ERR_WARN:     $lvl = "warning";  break;
			case PHPRPG_ERR_NOTICE:   $lvl = "notice";   break;
			}

			$line = "[$date] [$lvl] [$client] $error $page $lnum \r\n";

			$this->write($line);

			if ($level === PHPRPG_ERR_CRITICAL) exit('<br>'.$line.'<br>');

			return($line);
		}

		return(false);
	}

//PRIVATE:
	// Initialization function.
	function ERROR_REPORTER() {
		if (!defined('PHPRPG_ERROR_FILE')) $this->report(PHPRPG_ERR_CRITICAL, "No log file for initialization", __FILE__, __LINE__);
		if (!is_file(PHPRPG_ERROR_FILE)) $this->create(PHPRPG_ERROR_FILE);
	}

	// Create a file given $filepath.
	function create($filepath) {
		if (!touch($filepath)) {
			$this->report(PHPRPG_ERR_CRITICAL, "Can not access log file '$filepath'", __FILE__, __LINE__);
			return(false);
		}
		return(true);
	}

	// Low level write to log (doesn't append '\n' to $message)
	function write($message) {
		$fp = fopen(PHPRPG_ERROR_FILE, "a");
		if (!$fp) $this->report(PHPRPG_ERR_CRITICAL, "Can not write to log file '".PHPRPG_ERROR_FILE."'", __FILE__, __LINE__);
		if (!fwrite($fp,$message)) $this->report(PHPRPG_ERR_CRITICAL, "Can not append entry to log file '".PHPRPG_ERROR_FILE."'", __FILE__, __LINE__);
		fclose($fp);
		return($message);
	}
}


?>