<?php

if (!defined('PHPRPG_CHARACTER')) define('PHPRPG_CHARACTER', true);

require_once(PHPRPG_DIR.'/lib/action.lib.php');
require_once(PHPRPG_DIR.'/lib/attributes.lib.php');
require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/sprite.lib.php');

// Load Settings
define('PHPRPG_CHAR_ALL',     255);
define('PHPRPG_CHAR_ATTRIBS', 128);
define('PHPRPG_CHAR_TALENTS',  64);
define('PHPRPG_CHAR_MAGIC',    32);
define('PHPRPG_CHAR_SKILLS',   16);
define('PHPRPG_CHAR_EQUIP',     8);
define('PHPRPG_CHAR_IMAGES',    4);
define('PHPRPG_CHAR_STATS',     2);
define('PHPRPG_CHAR_CORE',      1);

// Internal Equipment slot identifiers
define('PHPRPG_SLOT_HEAD',        1);
define('PHPRPG_SLOT_NECK',        2);
define('PHPRPG_SLOT_CHEST',       4);
define('PHPRPG_SLOT_CAPE',        8);
define('PHPRPG_SLOT_BELT',       16);
define('PHPRPG_SLOT_FEET',       32);
define('PHPRPG_SLOT_RFINGER',    64);
define('PHPRPG_SLOT_LFINGER',   128);
define('PHPRPG_SLOT_RHAND',     256);
define('PHPRPG_SLOT_LHAND',     512);

class CHARACTER
{
//PUBLIC:
	var $id;
	var $name;
	var $size;
	var $hp;
	var $ac;
	var $ab;
	var $mana;
	var $stm;
	var $cap;
	var $currency;
	var $experience;
	var $loc;

	var $sprite;
	var $equipment;
	var $attribs;
	var $skills;
	var $spells;
	var $tallents;

	var $user;
	var $options;
	var $errors;

	function load($charId=0,$options=0) {

		$charId  = intval($charId);
		$options = intval($options);

		if ($charId < 1 && $this->id < 1) return(false);
		if ($charId < 1 && $this->id > 0) $charId = $this->id;

		if ($options != 0) $this->options = $options;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($options&PHPRPG_CHAR_CORE) {

			$table = PHPRPG_DB_PREFIX."_chars";
			$sql  = "SELECT CharId,CharName,CharSize,CharXP,CharCurrency,CharUser,CharMapId,CharLocId ";
			$sql .= "FROM $table WHERE CharId='$charId'";

			if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			list($this->id,
				 $this->name,
				 $this->size,
				 $this->experience,
				 $this->currency,
				 $this->user,
				 $this->loc['map'],
				 $this->loc['loc']) = mysql_fetch_row($dbObj->result);

			$dbObj->flush();
		}
		if ($options&PHPRPG_CHAR_STATS) {

			$table = PHPRPG_DB_PREFIX."_char_stats";
			$sql  = "SELECT CharStatStr,CharStatVit,CharStatAgl,CharStatChr,CharStatInt,CharStatWis,CharStatKrm,CharStatAge,CharStatAC,CharStatAB, ";
			$sql .= "       CharStatHPCur,CharStatHPMax,CharStatManaCur,CharStatManaMax,CharStatStmCur,CharStatStmMax,CharStatCapCur,CharStatCapMax ";
			$sql .= "FROM $table WHERE CharStatId='$charId'";

			if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			list($this->stats['Str'],
				 $this->stats['Vit'],
				 $this->stats['Agl'],
				 $this->stats['Chr'],
				 $this->stats['Int'],
				 $this->stats['Wis'],
				 $this->stats['Krm'],
				 $this->stats['Age'],
				 $this->ac,
				 $this->ab,
				 $this->hp['cur'],
				 $this->hp['max'],
				 $this->mana['cur'],
				 $this->mana['max'],
				 $this->stm['cur'],
				 $this->stm['max'],
				 $this->cap['cur'],
				 $this->cap['max']) = mysql_fetch_row($dbObj->result);

			$dbObj->flush();
		}
		if ($options&PHPRPG_CHAR_IMAGES) {
			$this->sprite = new SPRITE($this->id);
		}

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		$table01 = PHPRPG_DB_PREFIX.'_chars';
		$table03 = PHPRPG_DB_PREFIX.'_char_stats';
		$table04 = PHPRPG_DB_PREFIX.'_char_sprite';
		$table05 = PHPRPG_DB_PREFIX.'_char_equip';

		if ($this->id > 0) {
			if ($this->options&PHPRPG_CHAR_CORE) {
				$sql  = "UPDATE $table01 SET ";
				$sql .= "CharName='$this->name',CharSize='$this->size',CharUser='$this->user',CharMapId='".$this->loc['map']."',CharLocId='".$this->loc['loc']."',CharCurrency='".$this->currency."' ";
				$sql .= "WHERE CharId='$this->id'";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
			}
			if ($this->options&PHPRPG_CHAR_STATS) {
				$sql  = "UPDATE $table03 SET ";
				$sql .= "CharStatStr='".$this->stats['Str']."',CharStatVit='".$this->stats['Vit']."',CharStatAgl='".$this->stats['Agl']."',CharStatChr='".$this->stats['Chr']."', ";
				$sql .= "CharStatInt='".$this->stats['Int']."',CharStatWis='".$this->stats['Wis']."',CharStatKrm='".$this->stats['Krm']."',CharStatAge='".$this->stats['Age']."', ";
				$sql .= "CharStatAC='$this->ac',CharStatAB='$this->ab',CharStatHPCur='".$this->hp['cur']."',CharStatHPMax='".$this->hp['max']."',CharStatManaCur='".$this->mana['cur']."',CharStatManaMax='".$this->mana['max']."',CharStatStmCur='".$this->stm['cur']."',CharStatStmMax='".$this->stm['max']."',CharStatCapCur='".$this->cap['cur']."',CharStatCapMax='".$this->cap['max']."' ";
				$sql .= "WHERE CharStatId='$this->id'";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
			}
			if ($this->options&PHPRPG_CHAR_IMAGES) {
				$sql  = "UPDATE $table04 SET ";
				$sql .= "CharImageBody='".$this->sprite->body."', ";
				$sql .= "CharImageBodyPF='".serialize($this->sprite->body_pf)."', ";
				$sql .= "CharImageBodyHF='".serialize($this->sprite->body_hf)."', ";
				$sql .= "CharImageHair='".$this->sprite->hair."', ";
				$sql .= "CharImageHairPF='".serialize($this->sprite->hair_pf)."', ";
				$sql .= "CharImageHairHF='".serialize($this->sprite->hair_hf)."', ";
				$sql .= "CharImageWings='".$this->sprite->wings."', ";
				$sql .= "CharImageWingsPF='".serialize($this->sprite->wings_pf)."', ";
				$sql .= "CharImageWingsHF='".serialize($this->sprite->wings_hf)."', ";
				$sql .= "CharImageTail='".$this->sprite->tail."', ";
				$sql .= "CharImageTailPF='".serialize($this->sprite->tail_pf)."', ";
				$sql .= "CharImageTailHF='".serialize($this->sprite->tail_hf)."', ";
				$sql .= "CharImagePortrait='".$this->sprite->portrait."' ";
				$sql .= "WHERE CharImageId='$this->id'";
				if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
			}
		}
		else {

			$sql  = "INSERT INTO $table01 ";
			$sql .= "( CharName,CharUser,CharSize,CharMapId,CharLocId,CharCurrency )";
			$sql .= " VALUES ";
			$sql .= "( '$this->name','$this->user','$this->size','".$this->loc['map']."','".$this->loc['loc']."','".$this->currency."')";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$this->id = mysql_insert_id();

			$sql  = "INSERT INTO $table03 ";
			$sql .= "(CharStatId,CharStatStr,CharStatVit,CharStatAgl,CharStatChr,CharStatInt,CharStatWis,CharStatKrm, CharStatAge,CharStatAC,CharStatAB,CharStatHPCur,CharStatHPMax,CharStatManaCur,CharStatManaMax,CharStatStmCur,CharStatStmMax,CharStatCapCur,CharStatCapMax)";
			$sql .= " VALUES ";
			$sql .= "('$this->id','".$this->stats['Str']."','".$this->stats['Vit']."','".$this->stats['Agl']."','".$this->stats['Chr']."','".$this->stats['Int']."','".$this->stats['Wis']."','".$this->stats['Krm']."','".$this->stats['Age']."','$this->ac','$this->ab','".$this->hp['cur']."','".$this->hp['max']."','".$this->mana['cur']."','".$this->mana['max']."','".$this->stm['cur']."','".$this->stm['max']."','".$this->cap['cur']."','".$this->cap['max']."')";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$sql  = "INSERT INTO $table04 ";
			$sql .= "(CharImageId,CharImageBody,CharImageBodyPF,CharImageBodyHF,CharImageHair,CharImageHairPF,CharImageHairHF,CharImageWings, CharImageWingsPF,CharImageWingsHF,CharImageTail,CharImageTailPF,CharImageTailHF,CharImagePortrait)";
			$sql .= " VALUES ";
			$sql .= "('$this->id','".$this->sprite->body."','".serialize($this->sprite->body_pf)."','".serialize($this->sprite->body_hf)."','".$this->sprite->hair."','".serialize($this->sprite->hair_pf)."','".serialize($this->sprite->hair_hf)."','".$this->sprite->wings."','".serialize($this->sprite->wings_pf)."','".serialize($this->sprite->wings_hf)."','".$this->sprite->tail."','".serialize($this->sprite->tail_pf)."','".serialize($this->sprite->tail_hf)."','".$this->sprite->portrait."')";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$sql  = "INSERT INTO $table05 ";
			$sql .= "(CharEquipId)";
			$sql .= " VALUES ";
			$sql .= "('$this->id')";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function delete($id = 0) {

		$id = intval($id);

		if ($this->id > 0 && $id == 0) $id = $this->id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$this->errors = NULL;

		if ($id > 0) {
			$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$table = PHPRPG_DB_PREFIX.'_chars';
			$sql = "DELETE FROM $table WHERE CharId=$id";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$table = PHPRPG_DB_PREFIX.'_char_stats';
			$sql = "DELETE FROM $table WHERE CharStatId='$id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$table = PHPRPG_DB_PREFIX.'_char_sprite';
			$sql = "DELETE FROM $table WHERE CharImageId='$id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);

			$table = PHPRPG_DB_PREFIX.'_char_equip';
			$sql = "DELETE FROM $table WHERE CharEquipId='$id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR,$dbObj->error,__FILE__,__LINE__);
		}

		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {
		$this->options    = 0;
		$this->user       = 0;
		$this->id         = 0;
		$this->name       = '';
		$this->size       = 0;
		$this->currency   = 0;
		$this->experience = 0;

		$this->stats = array('Str'=>0,'Vit'=>0,'Agl'=>0,'Chr'=>0,'Int'=>0,'Wis'=>0,'Krm'=>0,'Age'=>0 );

		$this->loc['map'] = PHPRPG_START_MAP;
		$this->loc['loc'] = PHPRPG_START_LOC;

		$this->hp   = array('cur'=>0,'max'=>0);
		$this->mana = array('cur'=>0,'max'=>0);
		$this->stm  = array('cur'=>0,'max'=>0);
		$this->cap  = array('cur'=>0,'max'=>0);

		$this->sprite    = NULL;
		$this->equipment = NULL;
		$this->attribs   = NULL;
		$this->skills    = NULL;
		$this->spells    = NULL;
		$this->tallents  = NULL;
	}

	function getInventory($charId=0) {

		$charId = intval($charId);

		if ($charId < 1 && @$this->id < 1) return(false);
		if ($charId < 1 && @$this->id > 0) $charId = $this->id;

		$this->errors = NULL;
		$rtn          = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table01 = PHPRPG_DB_PREFIX."_items";
		$table02 = PHPRPG_DB_PREFIX."_char_equip";

		$sql  = "SELECT ItemId FROM $table01 ";
		$sql .= "LEFT OUTER JOIN $table02 AS ce ";
		$sql .= "ON ce.CharEquipId = $charId ";
		$sql .= "WHERE ItemLocType='".PHPRPG_CLASS_CHAR."' AND ItemLocId='$charId' ";
		$sql .= "AND ItemId != ce.CharEquipHead    AND ItemId != ce.CharEquipNeck ";
		$sql .= "AND ItemId != ce.CharEquipChest   AND ItemId != ce.CharEquipLegs ";
		$sql .= "AND ItemId != ce.CharEquipBack    AND ItemId != ce.CharEquipBelt ";
		$sql .= "AND ItemId != ce.CharEquipFeet    AND ItemId != ce.CharEquipRFinger ";
		$sql .= "AND ItemId != ce.CharEquipLFinger AND ItemId != ce.CharEquipRHand ";
		$sql .= "AND ItemId != ce.CharEquipLHand ";
		$sql .= "ORDER BY ItemLocation";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		while ($row = mysql_fetch_assoc($dbObj->result)) $rtn[] = $row['ItemId'];

		if (empty($this->errors)) return($rtn);
		return(false);

	}

	function getEquiped($charId=0) {

		$charId = intval($charId);

		if ($charId < 1 && @$this->id < 1) return(false);
		if ($charId < 1 && @$this->id > 0) $charId = $this->id;

		$this->errors = NULL;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();

		$table = PHPRPG_DB_PREFIX."_char_equip";

		$sql  = "SELECT * FROM $table WHERE CharEquipId='$charId' LIMIT 1";

		if (!($dbObj->query($sql))) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		$rtn = mysql_fetch_assoc($dbObj->result);

		if (empty($this->errors)) return($rtn);
		return(false);

	}

//PRIVATE:
	var $options;

	function CHARACTER($charId=0, $options=PHPRPG_CHAR_ALL) {

		$this->flush();
		$this->id = intval($charId);
		$this->options = intval($options);
		$this->sprite  = new SPRITE();

		if ($this->id > 0) return($this->load($this->id,$this->options));

		return(true);
	}
}


?>