<?php

function drawTileEditor() {


	$page  = new TEMPLATE('page');
	$olObj = new Overlib(PHPRPG_URL.'/lib/js');

	// HEADER INFORMATION
	$context_header = $olObj->init();

	$header_extras  = '<script type="text/javascript" language="JavaScript" src="'.PHPRPG_URL.'/lib/js/tile.js.php"></script>';
	$header_extras .= '<script type="text/javascript" language="JavaScript" src="'.PHPRPG_URL.'/lib/js/scriptload.js"></script>';

	$form_header  = "<form action='".PHPRPG_URL."/tiles.php' method='GET'>";

	$tile_editors = "<div id='tool-box' name='tool-box'>";



	// IMAGE REPOSITORY
	$tile_editors .= "<div class='editor' id='tile-editor-image' name='tile-editor-image'>";

	$context = $olObj->over('Scan the host for new images in the tile image directory.', 'Scan');
	$url = PHPRPG_URL.'/tiles.php?submit=Scan';
	$javascript = "onClick=\"doPopup('$url','Scan_Tile_Images',450,350,1);\"";
	$image_scan_button = "<input type='button' class='inputbutton' id='image-scan-button' name='image-scan-button' value='Scan' $context $javascript>";

	$context = $olObj->over('Upload a number of images to the tile image directory.', 'Upload');
	$url = PHPRPG_URL.'/tiles.php?submit=Upload+Image';
	$javascript = "onClick=\"doPopup('$url','Image_Uploader',500,175,1);\"";
	$image_upload_button = "<input type='button' class='inputbutton' id='upload-image-button' name='upload-image-button' value='Upload' $context $javascript>";

	$javascript = "onChange='showImages();'";
	$image_set_select  = "<select class='input' id='image-set-select' name='image-set-select' $javascript>";
	$image_set_select .= "<option value=''>Unsorted</option>";
	$image_set_select .= "</select>";

	$context = $olObj->over('Organize the available images.', '...');
	$url = "'".PHPRPG_URL."/tiles.php?submit=Organize+Images&tile-id='+iTile+'&terrain-id='+iTerrain+'&image-set='+sImageSet+'&old-image-set='+sImageSet";
	$javascript = "onClick=\"doPopup($url,'Organize_Image_Sets',525,350,1);\"";
	$image_set_editor_button = "<input type='button' class='inputbutton' id='image-set-editor-button' value='...' $context $javascript>";

	$images_in_set = '<div id="image-palette" name="image-palette"></div>';

	$page->define('IMAGE_SCAN_BUTTON',       $image_scan_button);
	$page->define('UPLOAD_IMAGE_BUTTON',     $image_upload_button);
	$page->define('IMAGE_SET_SELECT',        $image_set_select);
	$page->define('IMAGE_SET_EDITOR_BUTTON', $image_set_editor_button);
	$page->define('IMAGES_IN_SET',           $images_in_set);

	$tile_editors .= $page->build('admin_tiles_images');
	$tile_editors .= "</div>";

	$page->flush();



	// ATTRIBUTE EDITOR
	$tile_editors  .= "<div class='editor' id='tile-editor-attrib' name='tile-editor-attrib'>";

	$attrib_filter_input = "<input type='input' class='input' id='attrib-filter-input' name='attrib-filter-input'>";

	$context = $olObj->over('Filter the number of visable results.', 'Filter');
	$javascript = 'onClick="attribFilter();"';
	$attrib_filter_button = "<input type='button' class='inputbutton' id='attrib-filter-button' name='attrib-filter-button' value='Filter' $context $javascript>";

	$context = $olObj->over('Add new attribute to this tile.', 'New Attribute');
	$url = "'".PHPRPG_URL."/tiles.php?submit=Edit+Attributes&tile-id='+iTile";
	$javascript = "onClick=\"doPopup($url,'Edit_Attributes',525,350,0);\"";
	$attrib_new_button = "<input type='button' class='inputbutton' id='attrib-new-button' name='attrib-new-button' value='New Attribute' $context $javascript>";

	$attrib_table = '<div id="attribute-div" name="attribute-div"><table id="attribute-table" name="attribute-table"></table></div>';

	$page->define('ATTRIB_FILTER_INPUT',  $attrib_filter_input);
	$page->define('ATTRIB_FILTER_BUTTON', $attrib_filter_button);
	$page->define('ATTRIB_NEW_BUTTON',    $attrib_new_button);
	$page->define('ATTRIB_TABLE',         $attrib_table);

	$tile_editors .= $page->build('admin_tile_attrib');
	$tile_editors .= '</div>';

	$page->flush();



	// EVENT EDITOR
	$tile_editors  .= "<div class='editor' id='tile-editor-event' name='tile-editor-event'>";

	$context  = $olObj->over('Choose the script to use', 'Select');
	$context2 = $olObj->over('Remove this script association.', 'Del');

	$tile_attack_input  = "<input type='text' class='input' id='tile-event-attack-input' name='tile-event-attack-input' style='width:100%'>";
	$url = "'".PHPRPG_URL."/tiles.php?submit=Script+Select&tile-id='+iTile+'&tile-event=tile-event-attack'";
	$javascript = "onClick=\"doPopup($url,'Script_Select',300,400,1);\"";
	$tile_attack_button = "<input type='button' class='inputbutton' id='tile-event-attack-button' name='tile-event-attack-button' value='...' $context  $javascript>";

	$javascript = "onClick=\"delTileEvent(".PHPRPG_EVENT_ATTACK.");\"";
	$tile_attack_delete_button = "<input type='button' class='inputbutton' id='tile-event-attack-delete-button' name='tile-attack-event-delete-button' value='Del' $context2  $javascript>";


	$tile_defend_input  = "<input type='text' class='input' id='tile-event-defend-input' name='tile-event-defend-input' style='width:100%'>";
	$url = "'".PHPRPG_URL."/tiles.php?submit=Script+Select&tile-id='+iTile+'&tile-event=tile-event-defend'";
	$javascript = "onClick=\"doPopup($url,'Script_Select',300,400,1);\"";
	$tile_defend_button = "<input type='button' class='inputbutton' id='tile-event-defend-button' name='tile-event-defend-button' value='...' $context  $javascript>";

	$javascript = "onClick=\"delTileEvent(".PHPRPG_EVENT_DEFEND.");\"";
	$tile_defend_delete_button = "<input type='button' class='inputbutton' id='tile-event-defend-delete-button' name='tile-defend-event-delete-button' value='Del' $context2  $javascript>";


	$tile_enter_input  = "<input type='text' class='input' id='tile-event-enter-input' name='tile-event-enter-input' style='width:100%'>";
	$url = "'".PHPRPG_URL."/tiles.php?submit=Script+Select&tile-id='+iTile+'&tile-event=tile-event-enter'";
	$javascript = "onClick=\"doPopup($url,'Script_Select',300,400,1);\"";
	$tile_enter_button = "<input type='button' class='inputbutton' id='tile-event-enter-button' name='tile-event-enter-button' value='...' $context  $javascript>";

	$javascript = "onClick=\"delTileEvent(".PHPRPG_EVENT_ENTER.");\"";
	$tile_enter_delete_button = "<input type='button' class='inputbutton' id='tile-event-enter-delete-button' name='tile-enter-event-delete-button' value='Del' $context2  $javascript>";


	$tile_leave_input  = "<input type='text' class='input' id='tile-event-leave-input' name='tile-event-leave-input' style='width:100%'>";
	$url = "'".PHPRPG_URL."/tiles.php?submit=Script+Select&tile-id='+iTile+'&tile-event=tile-event-leave'";
	$javascript = "onClick=\"doPopup($url,'Script_Select',300,400,1);\"";
	$tile_leave_button = "<input type='button' class='inputbutton' id='tile-event-leave-button' name='tile-event-leave-button' value='...' $context  $javascript>";

	$javascript = "onClick=\"delTileEvent(".PHPRPG_EVENT_LEAVE.");\"";
	$tile_leave_delete_button = "<input type='button' class='inputbutton' id='tile-event-leave-delete-button' name='tile-leave-event-delete-button' value='Del' $context2  $javascript>";


	$tile_create_input  = "<input type='text' class='input' id='tile-event-create-input' name='tile-event-create-input' style='width:100%'>";
	$url = "'".PHPRPG_URL."/tiles.php?submit=Script+Select&tile-id='+iTile+'&tile-event=tile-event-create'";
	$javascript = "onClick=\"doPopup($url,'Script_Select',300,400,1);\"";
	$tile_create_button = "<input type='button' class='inputbutton' id='tile-event-create-button' name='tile-event-create-button' value='...' $context  $javascript>";

	$javascript = "onClick=\"delTileEvent(".PHPRPG_EVENT_CREATE.");\"";
	$tile_create_delete_button = "<input type='button' class='inputbutton' id='tile-event-create-delete-button' name='tile-create-event-delete-button' value='Del' $context2  $javascript>";


	$tile_destroy_input  = "<input type='text' class='input' id='tile-event-destroy-input' name='tile-event-destroy-input' style='width:100%'>";
	$url = "'".PHPRPG_URL."/tiles.php?submit=Script+Select&tile-id='+iTile+'&tile-event=tile-event-destroy'";
	$javascript = "onClick=\"doPopup($url,'Script_Select',300,400,1);\"";
	$tile_destroy_button = "<input type='button' class='inputbutton' id='tile-event-destroy-button' name='tile-event-destroy-button' value='...' $context  $javascript>";

	$javascript = "onClick=\"delTileEvent(".PHPRPG_EVENT_DESTROY.");\"";
	$tile_destroy_delete_button = "<input type='button' class='inputbutton' id='tile-event-destroy-delete-button' name='tile-destroy-event-delete-button' value='Del' $context2  $javascript>";

	$page->define('TILE_ATTACK_INPUT',          $tile_attack_input);
	$page->define('TILE_ATTACK_BUTTON',         $tile_attack_button);
	$page->define('TILE_ATTACK_DELETE_BUTTON',  $tile_attack_delete_button);
	$page->define('TILE_DEFEND_INPUT',          $tile_defend_input);
	$page->define('TILE_DEFEND_BUTTON',         $tile_defend_button);
	$page->define('TILE_DEFEND_DELETE_BUTTON',  $tile_defend_delete_button);
	$page->define('TILE_ENTER_INPUT',           $tile_enter_input);
	$page->define('TILE_ENTER_BUTTON',          $tile_enter_button);
	$page->define('TILE_ENTER_DELETE_BUTTON',   $tile_enter_delete_button);
	$page->define('TILE_LEAVE_INPUT',           $tile_leave_input);
	$page->define('TILE_LEAVE_BUTTON',          $tile_leave_button);
	$page->define('TILE_LEAVE_DELETE_BUTTON',   $tile_leave_delete_button);
	$page->define('TILE_CREATE_INPUT',          $tile_create_input);
	$page->define('TILE_CREATE_BUTTON',         $tile_create_button);
	$page->define('TILE_CREATE_DELETE_BUTTON',  $tile_create_delete_button);
	$page->define('TILE_DESTROY_INPUT',         $tile_destroy_input);
	$page->define('TILE_DESTROY_BUTTON',        $tile_destroy_button);
	$page->define('TILE_DESTROY_DELETE_BUTTON', $tile_destroy_delete_button);

	$tile_editors .= $page->build('admin_tile_event');
	$tile_editors .= '</div>';

	$page->flush();



	// TILESET EDITOR AND COMPONENTS
	$javascript = 'onChange="if (checkForm()) showTiles(); else this.selectedIndex=iTerrain;"';
	$terrain_select  = "<select class='input' id='terrain-select' name='terrain-select' $javascript>";
	$terrain_select .= "<option> - select set - </option>";
	$terrain_select .= '</select>';

	$context = $olObj->over('Organize the available terrain.', '...');
	$url = "'".PHPRPG_URL."/tiles.php?submit=Organize+Terrain&terrain-id='+iTerrain";
	$javascript = "onClick=\"if (checkForm()) doPopup($url,'Organize_Terrain',450,200);\"";
	$terrain_edit_button = "<input type='button' class='inputbutton' id='terrain-edit-button' name='terrain-edit-button' value='...' $context $javascript>";

	$javascript = "onChange='editorSelect();'";
	$tile_editor_select  = "<select class='input' id='tile-editor-select' name='tile-editor-select' $javascript>";
	$tile_editor_select .= "<option> - select sub editor - </options>";
	$tile_editor_select .= "<option>Image Selector</options>";
	$tile_editor_select .= "<option>Tile Events</options>";
	$tile_editor_select .= "<option>Tile Attributes</options>";
	$tile_editor_select .= "</select>";

	$tile_image = "<img src='".PHPRPG_URL."/share/images/default_tile.png' id='tile-display-image' name='tile-display-image' width='100' height='100'>";

	$context = $olObj->over('The mount of stamina required to traverse a tile.  Stamina can be set directionally. To restrict access a negitive values should be used.', 'Movement Cost');
	$tile_movement_context = "<div id='movement_context' name='movement_context' $context >Movement Cost:</div>";

	$context = $olObj->over('North', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_dn_cost = "<input type='text' class='input' id='tile-dn-cost' name='tile-dn-cost' size='3' $context $javascript>";

	$context = $olObj->over('North East', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_ne_cost = "<input type='text' class='input' id='tile-ne-cost' name='tile-ne-cost' size='3' $context $javascript>";

	$context = $olObj->over('East', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_de_cost = "<input type='text' class='input' id='tile-de-cost' name='tile-de-cost' size='3' $context $javascript>";

	$context = $olObj->over('South East', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_se_cost = "<input type='text' class='input' id='tile-se-cost' name='tile-se-cost' size='3' $context $javascript>";

	$context = $olObj->over('South', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_ds_cost = "<input type='text' class='input' id='tile-ds-cost' name='tile-ds-cost' size='3' $context $javascript>";

	$context = $olObj->over('South West', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_sw_cost = "<input type='text' class='input' id='tile-sw-cost' name='tile-sw-cost' size='3' $context $javascript>";

	$context = $olObj->over('West', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_dw_cost = "<input type='text' class='input' id='tile-dw-cost' name='tile-dw-cost' size='3' $context $javascript>";

	$context = $olObj->over('North West', 'Movement Cost');
	$javascript = "onChange='changeForm();'";
	$tile_nw_cost = "<input type='text' class='input' id='tile-nw-cost' name='tile-nw-cost' size='3' $context $javascript>";

	$javascript = "onChange='changeForm();'";
	$tile_name_input = "<input type='text' class='input' id='tile-name-input' name='tile-name' maxlength='32' style='width:100%' $javascript>";

	$javascript = "onChange='changeForm();'";
	$tile_terrain_select  = "<select class='input' id='tile-terrain-select' name='tile-terrain-id' style='width:100%' $javascript>";
	$tile_terrain_select .= "<option value=''>No Type</option>";
	$tile_terrain_select .= "</select>";

	$context = $olObj->over('Should other tiles be able to replace this tile? Checked if yes, unchecked if no.', 'Build Over');
	$tile_override_context = "<div id='tile-override_context' $context>Build Over:</div>";

	$javascript = "onChange='changeForm();'";
	$tile_override_checkbox = "<input type='checkbox' id='tile-override-checkbox' name='tile-override' value='1' $javascript>";

	$context = $olObj->over('Save the current tile.', 'Save');
	$javascript = 'onClick="saveTile()"';
	$tile_save_button = "<input type='button' class='inputbutton' id='tile-save-button' name='tile-save-button' value='Save' $context $javascript>";

	$context = $olObj->over('Save the current tile as a new tile.', 'Save');
	$javascript = 'onClick="saveTile(true)"';
	$tile_saveas_button = "<input type='button' class='inputbutton' id='tile-saveas-button' name='tile-saveas-button' value='Save As' $context $javascript>";

	$context = $olObj->over('Create a new tiles in this set.', 'New');
	$javascript = "onClick='if (checkForm()) newTile();'";
	$tile_new_button = "<input type='button' class='inputbutton' id='tile-new-button' name='tile-new-button' value='New' $context $javascript>";

	$context = $olObj->over('Delete the current tile from the set.', 'Delete');
	$javascript = "onClick='if (confirm(\"Are you sure you want to remove this tile?\")) deleteTile();'";
	$tile_delete_button = "<input type='button' class='inputbutton' id='tile-delete-button' name='tile-delete-button' value='Delete' $context $javascript>";

	$tile_palette = '<div id="tile-palette" name="tile-palette"></div>';

	$tile_editors .= "</div>";



	// BUILD AND RETURN TILE EDITOR
	$page->define('TITLE',                     'PHPRPG Admin - Tile Editor');
	$page->define('HEADER_EXTRAS',             $header_extras);
	$page->define('PROGRAM_NAME',              'Tile Editor ::');
	$page->define('ADMIN_MENU',                drawMenu(TRUE));
	$page->define('CONTEXT_HEADER',            $context_header);
	$page->define('ERROR',                     '');
	$page->define('FORM_HEADER',               $form_header);
	$page->define('TERRAIN_SELECT',            $terrain_select);
	$page->define('TERRAIN_EDIT_BUTTON',       $terrain_edit_button);
	$page->define('TILE_EDITOR_SELECT',        $tile_editor_select);
	$page->define('TILE_EDITORS',              $tile_editors);
	$page->define('TILE_IMAGE',                $tile_image);
	$page->define('TILE_MOVEMENT_CONTEXT',     $tile_movement_context);
	$page->define('TILE_DN_COST',              $tile_dn_cost);
	$page->define('TILE_NE_COST',              $tile_ne_cost);
	$page->define('TILE_DE_COST',              $tile_de_cost);
	$page->define('TILE_SE_COST',              $tile_se_cost);
	$page->define('TILE_DS_COST',              $tile_ds_cost);
	$page->define('TILE_SW_COST',              $tile_sw_cost);
	$page->define('TILE_DW_COST',              $tile_dw_cost);
	$page->define('TILE_NW_COST',              $tile_nw_cost);
	$page->define('TILE_NAME_INPUT',           $tile_name_input);
	$page->define('TILE_TERRAIN_SELECT',       $tile_terrain_select);
	$page->define('TILE_OVERRIDE_CONTEXT',     $tile_override_context);
	$page->define('TILE_OVERRIDE_CHECKBOX',    $tile_override_checkbox);
	$page->define('TILE_SAVE_BUTTON',          $tile_save_button);
	$page->define('TILE_SAVEAS_BUTTON',        $tile_saveas_button);
	$page->define('TILE_NEW_BUTTON',           $tile_new_button);
	$page->define('TILE_DELETE_BUTTON',        $tile_delete_button);
	$page->define('TILE_PALETTE',              $tile_palette);

	return($page->build('admin_tiles'));
}


?>