<?php

function drawTerrainEditor(&$terrainId,&$action) {

	$olObj = new Overlib(PHPRPG_URL.'/lib/js');
	$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);

	switch($action) {
	case "Save As":
		$terrainId = 0;
	case "Save":

		$rtn  = "\n<script language=\"JavaScript\">";

		$port_space = empty($_GET['terrain-space-port']) ? 0 : PHPRPG_PORT_SPACE;
		$port_air   = empty($_GET['terrain-air-port']  ) ? 0 : PHPRPG_PORT_AIR;
		$port_sea   = empty($_GET['terrain-sea-port']  ) ? 0 : PHPRPG_PORT_SEA;

		$terrain_name  = @trim($_GET['terrain-input']);
		$terrain_state = @trim($_GET['terrain-state']);

		if (!empty($terrain_name)) {

			$saveObj = new TERRAIN($terrainId);
			$saveObj->name = $terrain_name;
			$saveObj->state = $terrain_state;
			$saveObj->portType = ($port_space+$port_sea+$port_air);
			$saveObj->save(); // DO REAL ERROR REPORTING

			$terrain_id = $saveObj->id;
		}

		if (empty($terrainId) && !empty($terrain_id)) {

			require_once(PHPRPG_DIR.'/lib/tile.lib.php');

			$saveObj = new TILE();
			$saveObj->terrainId = $terrain_id;
			$saveObj->save();  // DO REAL ERROR REPORTING
		}

		$rtn .= "\n location.href = \"".PHPRPG_URL."/tiles.php?submit=Organize+Terrain&terrain-id=$terrain_id\";";
		$rtn .= "\n</script>";
		exit($rtn);

	case "Delete":
		if ($terrainId) {
			$delObj = new TERRAIN();
			$delObj->delete($terrainId); // DO REAL ERROR REPORTING

			$rtn  = "\n<script language=\"JavaScript\">";
			$rtn .= "\n location.href = \"".PHPRPG_URL."/tiles.php?submit=Organize+Terrain\";";
			$rtn .= "\n</script>";

			exit($rtn);
		}
		break;
	case "Close":
		$rtn  = "\n<script language=\"JavaScript\">";
		$rtn .= "\n window.opener.loadPage()";
		$rtn .= "\n window.close()";
		$rtn .= "\n</script>";
		exit($rtn);
	case "New":
		$terrainId = 0;
		break;
	}

	$loadObj = new TERRAIN($terrainId);
	$terrain_name = $loadObj->name;

	$state_solid = "";
	$state_liquid = "";
	$state_gaseous = "";
	$state_vacuum = "";

	switch($loadObj->state) {
	default: $state_solid = "selected"; break;
	case  1: $state_liquid = "selected"; break;
	case  2: $state_gaseous = "selected"; break;
	case  3: $state_vacuum = "selected"; break;
	}

	$port_sea = "";
	$port_air = "";
	$port_space = "";

	switch($loadObj->portType) {
	case 7:
		$port_sea   = "checked";
		$port_air   = "checked";
		$port_space = "checked";
		break;
	case 6:
		$port_sea = "checked";
		$port_air = "checked";
		break;
	case 5:
		$port_sea   = "checked";
		$port_space = "checked";
		break;
	case 4:
		$port_sea = "checked";
		break;
	case 3:
		$port_air   = "checked";
		$port_space = "checked";
		break;
	case 2:
		$port_air = "checked";
		break;
	case 1:
		$port_space = "checked";
		break;
	}



	// HEADER INFORMATION
	$header_extras  = $olObj->init();
	$header_extras .= "\n<script language=\"JavaScript\">";
	$header_extras .= "\n function goLocation(id) {";
	$header_extras .= "\n  url = \"".PHPRPG_URL."/tiles.php?submit=Organize+Terrain&terrain-id=\"+id;";
	$header_extras .= "\n  document.location = url;";
	$header_extras .= "\n }";
	$header_extras .= "\n</script>";

	$form_header  = "\n<form action='".PHPRPG_URL."/tiles.php' method='GET'>";
	$form_header .= "\n<input type='hidden' name='submit' value='Organize Terrain'>";
	$form_header .= "\n<input type='hidden' name='terrain-id' value='$terrainId'>";



	// DRAW TERRAIN SELECTOR
	$javascript = "onChange='goLocation(this.value)';";
	$terrain_select  = "<select class='input' id='terrain-select' name='terrain-id' $javascript>";
	$terrain_select .= "<option value='0'> - Select Terrain - </option>";

	$table = PHPRPG_DB_PREFIX."_tile_terrain";
	$sql = "SELECT TerrainName,TerrainId FROM $table ORDER BY TerrainName";
	if (!$dbObj->query($sql)) die($dbObj->error);
	if ($row = mysql_fetch_assoc($dbObj->result)) {
		do {
			$set = $row['TerrainName'];
			$id  = $row['TerrainId'];
			if ($id == $terrainId) $select = 'selected';
			else $select = '';
			$terrain_select .= "\n\t<option value='$id' $select>$set</option>";
		}
		while($row = mysql_fetch_assoc($dbObj->result));
	}
	$dbObj->flush();
	$terrain_select .= "\n</select>";



	// DRAW PORT TYPES
	$context = $olObj->over('Space vessels can access this terrain type.', 'Space Port');
	$terrain_space_check = "<input type='checkbox' id='terrain-space-port-checkbox' name='terrain-space-port' $context onChange='iDataState=1;' $port_space>";

	$context = $olObj->over('Air ships can access this terrain type.', 'Air Port');
	$terrain_air_check = "<input type='checkbox' id='terrain-air-port-checkbox' name='terrain-air-port' $context onChange='iDataState=1;' $port_air>";

	$context = $olObj->over('Sea fairing vessels can access this terrain type.', 'Sea Port');
	$terrain_sea_check = "<input type='checkbox' id='terrain-sea-port-checkbox' name='terrain-sea-port' $context onChange='iDataState=1;' $port_sea>";



	// DRAW TERRAIN STATE
	$terrain_state  = "<select class='input' id='terrain-state-select' name='terrain-state'>";
	$terrain_state .= "<option value='0' $state_solid>Solid</option>";
	$terrain_state .= "<option value='1' $state_liquid>Liquid</option>";
	$terrain_state .= "<option value='2' $state_gaseous>Gaseous</option>";
	$terrain_state .= "<option value='3' $state_vacuum>Vacuum</option>";
	$terrain_state .= "</select>";



	// DRAW TERRAIN INPUT
	$terrain_input = "<input type='text' class='input' id='terrain-input' name='terrain-input' value='$terrain_name'>";



	// DRAW BUTTONS
	$context = $olObj->over('Save the current terrain.', 'Save');
	$terrain_save_button = "<input type='submit' class='inputbutton' id='terrain-save-button' name='action' value='Save' $context $javascript>";

	$context = $olObj->over('Save the current terrain as a new terrain.', 'Save As');
	$terrain_saveas_button = "<input type='submit' class='inputbutton' id='terrain-saveas-button' name='action' value='Save As' $context $javascript>";

	$context = $olObj->over('Delete the current terrain.', 'Delete');
	$javascript = "onClick='return(confirm(\"Are you sure you want to remove this terrain and unassocaite all the current tiles?\"))'";
	$terrain_delete_button = "<input type='submit' class='inputbutton' id='terrain-delete-button' name='action' value='Delete' $context $javascript>";

	$javascript = "onClick='return(confirm(\"Are you sure you want to clear all data?\"))'";
	$context = $olObj->over('New Terrain Type.', 'New');
	$terrain_new_button = "<input type='submit' class='inputbutton' id='terrain-clear-button' name='action' value='New' $context $javascript>";

	$context = $olObj->over('Close this popup.', 'Close');
	$terrain_close_button = "<input type='submit' class='inputbutton' id='terrain-close-button' name='action' value='Close' $context>";



	$page = new TEMPLATE('page');
	$page->define('TITLE',		  'PHPRPG - Tile Set Organizer');
	$page->define('HEADER_EXTRAS',	  $header_extras);
	$page->define('FORM_HEADER',	    $form_header);
	$page->define('TERRAIN_SELECT',	 $terrain_select);
	$page->define('TERRAIN_SAVE_BUTTON',    $terrain_save_button);
	$page->define('TERRAIN_SAVEAS_BUTTON',  $terrain_saveas_button);
	$page->define('TERRAIN_NEW_BUTTON',     $terrain_new_button);
	$page->define('TERRAIN_DELETE_BUTTON',  $terrain_delete_button);
	$page->define('TERRAIN_CLOSE_BUTTON',   $terrain_close_button);
	$page->define('TERRAIN_INPUT',	  $terrain_input);
	$page->define('TERRAIN_STATE',	  $terrain_state);
	$page->define('TERRAIN_SPACE_CHECK',    $terrain_space_check);
	$page->define('TERRAIN_AIR_CHECK',      $terrain_air_check);
	$page->define('TERRAIN_SEA_CHECK',      $terrain_sea_check);

	return($page->build('admin_tiles_terrain'));
}


?>
