<?php

function drawAttributeEditor(&$tileId,&$action,&$attribKey,&$attribValue,&$attribKeyOld) {

	switch ($action) {
	default:
		if (!empty($attribKey) && $tileId > 0) {
			$loadObj = new ATTRIBUTES($tileId, PHPRPG_CLASS_TILE);
			$attribs = $loadObj->get($attribKey);
			$attribValue = $attribs['Value'];
			$attribKey   = $attribs['Key'];
		}
		break;

	case 'Save Attribute':

		$key = trim($attribKey);
		$val = trim($attribValue);
		$old = trim($attribKeyOld);

		if (empty($key) || $tileId < 1) break;

		$saveObj = new ATTRIBUTES($tileId, PHPRPG_CLASS_TILE);
		$attrib = $saveObj->get($key);

		if (empty($attrib)) $saveObj->add($key,$val);
		else $saveObj->mod($old,$key,$val);

		exit(header('location: '.PHPRPG_URL."/tiles.php?submit=Edit+Attributes&tile-id=$tileId&attrib-key=$key"));

	case 'Close':

		$rtn  = "\n<script language=\"JavaScript\">";
		$rtn .= "\n window.opener.editorSelect();";
		$rtn .= "\n window.close();";
		$rtn .= "\n</script>";

		exit($rtn);
	}

	$form_header  = "\n <form>";
	$form_header .= "\n <input type='hidden' name='tile-id' value='$tileId'>";
	$form_header .= "\n <input type='hidden' name='attrib-key-old' value='$attribKey'>";
	$form_header .= "\n <input type='hidden' name='submit' value='Edit Attributes'>";

	$item_attrib_key = "<input type='text' name='attrib-key' class='input' style='width:100%' value='$attribKey'>";
	$item_attrib_val = "<textarea name='attrib-value' class='input' style='width:100%' rows='10'>$attribValue</textarea>";
	$item_attrib_save  = "<input type='submit' name='action' value='Save Attribute' class='inputbutton'>";
	$item_attrib_reset = "<input type='reset'  name='reset'  value='Reset' class='inputbutton'>";
	$item_attrib_close = "<input type='submit' name='action' value='Close' class='inputbutton'>";

	$page = new TEMPLATE('page');
	$page->define('HEADER_EXTRAS', '');
	$page->define('FORM_HEADER', $form_header);
	$page->define('TITLE', 'PHPRPG Admin - Attribute Editor');
	$page->define('ITEM_ATTRIB_KEY',   $item_attrib_key);
	$page->define('ITEM_ATTRIB_VAL',   $item_attrib_val);
	$page->define('ITEM_ATTRIB_SAVE',  $item_attrib_save);
	$page->define('ITEM_ATTRIB_RESET', $item_attrib_reset);
	$page->define('ITEM_ATTRIB_CLOSE', $item_attrib_close);

	return($page->build('admin_item_attrib_new'));
}


?>
