<?php
require_once(PHPRPG_DIR.'/lib/character.lib.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/terrain.lib.php');

function drawMapEditor(&$terrainId) {

	if (empty($_SESSION['PHPRPG']['admin_map']) || empty($_SESSION['PHPRPG']['admin_zyx'])) {
		$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId'], PHPRPG_CHAR_CORE);
		$_SESSION['PHPRPG']['admin_map'] = $objChar->loc['map'];
		$_SESSION['PHPRPG']['admin_zyx'] = MAP::getCoords($objChar->loc['loc'],$_SESSION['PHPRPG']['admin_map']);
		unset($objChar);
	}

	$mapId = $_SESSION['PHPRPG']['admin_map'];
	$arrCoords = $_SESSION['PHPRPG']['admin_zyx'];

	$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);

	$table01 = PHPRPG_DB_PREFIX.'_tiles';
	$table02 = PHPRPG_DB_PREFIX.'_tile_images';

	$olObj = new Overlib(PHPRPG_URL.'/lib/js');
	$context_header = $olObj->init();


	// MAP SELECT AND DETAILS
	$map_select  = '<select class="input" id="map-select" onChange="loadMap()">';
	$map_select .= '<option value="-1"> - new map - </option>';
	$sql = 'SELECT MapId, MapName
		FROM '.PHPRPG_DB_PREFIX.'_maps
		ORDER BY MapName';
	if (!$dbObj->query($sql)) exit($dbObj->error);
	if ($row = mysql_fetch_array($dbObj->result)) {
		do {
			$map_select .= '<option value="'.$row['MapId'].'"';
			if($row['MapId'] == $mapId) $map_select .= ' selected';
			$map_select .= '>'.$row['MapName'].'</option>';
		} while ($row = mysql_fetch_array($dbObj->result));
	}
	$dbObj->flush();
	$map_select .= '</select>';

	// If we have a map selected in memory (session) then load it's details into $map
	$map = array();
	$map_name = htmlspecialchars(@$map['MapName']);
	$map_name_input = '<input type="text" id="map-name" size="20" maxlength="20" value="'.$map_name.'" />';
	$map_default_tile = intval(@$map['MapDefTile']);
	$map_default_tile_input = '<input type="hidden" id="map-default-tile" value="'.$map_default_tile.'" />';
	$map_default_tile_path = TILE::getImagePath($map_default_tile);
	$map_default_tile_img = '<img id="map-default-tile-img" src="'.PHPRPG_URL.$map_default_tile_path.'" alt="" onclick="defineDefaultTile(this);" />';
	$map_size_x = @$map['MapSizeX'];
	$map_size_x_input = '<input type="text" id="map-size-x" size="3" maxlength="3" value="'.$map_size_x.'" />';
	$map_size_y = @$map['MapSizeY'];
	$map_size_y_input = '<input type="text" id="map-size-y" size="3" maxlength="3" value="'.$map_size_y.'" />';
	$map_size_z = @$map['MapSizeZ'];
	$map_size_z_input = '<input type="text" id="map-size-z" size="3" maxlength="3" value="'.$map_size_z.'" />';
	$map_wrap_x = @$map['WrapX'];
	$map_wrap_x_input = '<input type="checkbox" id="map-wrap-x" value="Y"'.($map_wrap_x=='Y'?' checked':'').' />';
	$map_wrap_y = @$map['WrapY'];
	$map_wrap_y_input = '<input type="checkbox" id="map-wrap-y" value="Y"'.($map_wrap_y=='Y'?' checked':'').' />';
	$map_wrap_z = @$map['WrapZ'];
	$map_wrap_z_input = '<input type="checkbox" id="map-wrap-z" value="Y"'.($map_wrap_z=='Y'?' checked':'').' />';
	$map_reset_input = '<input type="button" class="inputbutton"  onclick="loadMap();return(false);" value="Reset">';
	$map_update_input = '<input type="submit" class="inputbutton"  value="Update" />';

	$link_src_map_display = '<span id="link-src-map">-</span>';
	$link_src_x_display = '<span id="link-src-x">-</span>';
	$link_src_y_display = '<span id="link-src-y">-</span>';
	$link_src_z_display = '<span id="link-src-z">-</span>';
	$link_dst_map_select  = '<select class="input" id="link-dst-map">';
	$link_dst_map_select .= '<option value="0"></option>';
	$sql = 'SELECT MapId, MapName
		FROM '.PHPRPG_DB_PREFIX.'_maps
		ORDER BY MapName';
	if (!$dbObj->query($sql)) exit($dbObj->error);
	if ($row = mysql_fetch_array($dbObj->result)) {
		do {
			$link_dst_map_select .= '<option value="'.$row['MapId'].'">'.$row['MapName'].'</option>';
		} while ($row = mysql_fetch_array($dbObj->result));
	}
	$dbObj->flush();
	$link_dst_map_select .= '</select>';
	$link_dst_picker = '<input type="button" class="inputbutton" onclick="linkPicker();return(false);" value="Pick Dest">';
	$link_dst_x_input = '<input type="text" id="link-dst-x" size="3" value="" />';
	$link_dst_y_input = '<input type="text" id="link-dst-y" size="3" value="" />';
	$link_dst_z_input = '<input type="text" id="link-dst-z" size="3" value="" />';
	$link_cost_input = '<input type="text" id="link-cost" size="3" value="" />';
	$link_reset_input = '<input type="button" class="inputbutton" onclick="loadLink();return(false);" value="Reset">';
	$link_update_input = '<input type="submit" class="inputbutton" value="Update" />';

	$context = $olObj->over('Organize the available maps.', '...');
	$url = PHPRPG_URL.'/maps.php?submit=Organize+Maps';
	$javascript = "onClick=\"doPopup('$url','Organize_Maps',350,150);\"";
	$map_editor_button = '<input type="button" class="inputbutton" id="map_editor_button" name="organize_maps" value="..." '.$context.' '.$javascript.' />';


	// DRAW MAP TABLE
	$map_table = '<table class="map" id="map-table" cellpadding="0" cellspacing="0">';
	for($row=-PHPRPG_EDIT_HEIGHT; $row<=PHPRPG_EDIT_HEIGHT; $row++) {
		$map_table .= '<tr class="map">';
		for($cell=-PHPRPG_EDIT_WIDTH; $cell<=PHPRPG_EDIT_WIDTH; $cell++) {
			$action = 'defineLocation(this)';
			$x = $arrCoords['x'] + $cell;
			$y = $arrCoords['y'] + $row;
			$cellid = $x.'|'.$y;
			$celldata = '<img src="'.PHPRPG_URL.'/share/images/default_tile.png" alt="('.$x.','.$y.')" />';
			$map_table .= '<td class="map" id="'.$cellid.'" onclick="'.$action.'">'.$celldata.'</td>';
		}
		$map_table .= '</tr>';
	}
	$map_table .= '</table>';


	// DRAW TILE REPOSITORY
	$tile_set_select  = '<select id="palette-select" class="input" onChange="showTiles(this);">';
	$tile_set_select .= '<option value="">Unsorted</option>';
	foreach (TERRAIN::unique($terrainId) as $value) {
		$id = $value['value'];
		$set = $value['name'];
		$select = $value['selected'];
		$tile_set_select .= "<option value='$id' $select>$set</option>";
	}
	$tile_set_select .= "</select>";

	$tile_palette = '<div id="tile-palette">';
	if ($terrainId) {
		$sql = 'SELECT TileId,TileImagePath
			FROM '.$table01.','.$table02.'
			WHERE '.$table01.'.TileImage='.$table02.'.TileImageId
			AND TileTerrain='.$terrainId;
		if (!$dbObj->query($query)) exit($dbObj->error);
		if ($row = mysql_fetch_assoc($dbObj->result)) {
			do {
				$tile_palette .= '<img id="tile-'.$row['TileId'].' name="tile" class="tile" onClick="selectTile('.$row['TileId'].');" src="'.PHPRPG_URL.$row['TileImagePath'].'" />';
			}
			while ($row = mysql_fetch_assoc($dbObj->result));
		}
		$dbObj->flush();
	}
	$tile_palette .= '</div>';

	$refresh = 'loadMap();';
	$move_dn = 'move(0,-5,0);';
	$move_ne = 'move(5,-5,0);';
	$move_de = 'move(5,0,0);';
	$move_se = 'move(5,5,0);';
	$move_ds = 'move(0,5,0);';
	$move_sw = 'move(-5,5,0);';
	$move_dw = 'move(-5,0,0);';
	$move_nw = 'move(-5,-5,0);';
	$move_du = 'move(0,0,1);';
	$move_dd = 'move(0,0,-1);';

	// BUILD AND RETURN TILE EDITOR
	$page = new TEMPLATE('page');
	$page->define('TITLE',                  'PHPRPG Admin - Map Editor');
	$page->define('HEADER_EXTRAS',          drawHeaderExtras());
	$page->define('PROGRAM_NAME',           'Map Editor ::');
	$page->define('ADMIN_MENU',             drawMenu(TRUE));
	$page->define('CONTEXT_HEADER',         $context_header);
	$page->define('MAP_SELECT',             $map_select);
	$page->define('MAP_NAME',               $map_name);
	$page->define('MAP_NAME_INPUT',         $map_name_input);
	$page->define('MAP_DEFAULT_TILE',       $map_default_tile);
	$page->define('MAP_DEFAULT_TILE_INPUT', $map_default_tile_input);
	$page->define('MAP_DEFAULT_TILE_PATH',  $map_default_tile_path);
	$page->define('MAP_DEFAULT_TILE_IMG',   $map_default_tile_img);
	$page->define('MAP_SIZE_X',             $map_size_x);
	$page->define('MAP_SIZE_X_INPUT',       $map_size_x_input);
	$page->define('MAP_SIZE_Y',             $map_size_y);
	$page->define('MAP_SIZE_Y_INPUT',       $map_size_y_input);
	$page->define('MAP_SIZE_Z',             $map_size_z);
	$page->define('MAP_SIZE_Z_INPUT',       $map_size_z_input);
	$page->define('MAP_WRAP_X',             $map_wrap_x);
	$page->define('MAP_WRAP_X_INPUT',       $map_wrap_x_input);
	$page->define('MAP_WRAP_Y',             $map_wrap_y);
	$page->define('MAP_WRAP_Y_INPUT',       $map_wrap_y_input);
	$page->define('MAP_WRAP_Z',             $map_wrap_z);
	$page->define('MAP_WRAP_Z_INPUT',       $map_wrap_z_input);
	$page->define('MAP_RESET_INPUT',        $map_reset_input);
	$page->define('MAP_UPDATE_INPUT',       $map_update_input);
	$page->define('MAP_EDITOR_BUTTON',      $map_editor_button);
	$page->define('MAP_TABLE',              $map_table);
	$page->define('TILE_SET_SELECT',        $tile_set_select);
	$page->define('TILE_PALETTE',           $tile_palette);
	$page->define('REFRESH',                $refresh);
	$page->define('MOVE_DN',                $move_dn);
	$page->define('MOVE_NE',                $move_ne);
	$page->define('MOVE_DE',                $move_de);
	$page->define('MOVE_SE',                $move_se);
	$page->define('MOVE_DS',                $move_ds);
	$page->define('MOVE_SW',                $move_sw);
	$page->define('MOVE_DW',                $move_dw);
	$page->define('MOVE_NW',                $move_nw);
	$page->define('MOVE_DU',                $move_du);
	$page->define('MOVE_DD',                $move_dd);
	$page->define('LINK_SRC_MAP_DISPLAY',   $link_src_map_display);
	$page->define('LINK_SRC_X_DISPLAY',     $link_src_x_display);
	$page->define('LINK_SRC_Y_DISPLAY',     $link_src_y_display);
	$page->define('LINK_SRC_Z_DISPLAY',     $link_src_z_display);
	$page->define('LINK_DST_MAP_SELECT',    $link_dst_map_select);
	$page->define('LINK_DST_PICKER',        $link_dst_picker);
	$page->define('LINK_DST_X_INPUT',       $link_dst_x_input);
	$page->define('LINK_DST_Y_INPUT',       $link_dst_y_input);
	$page->define('LINK_DST_Z_INPUT',       $link_dst_z_input);
	$page->define('LINK_COST_INPUT',        $link_cost_input);
	$page->define('LINK_RESET_INPUT',       $link_reset_input);
	$page->define('LINK_UPDATE_INPUT',      $link_update_input);
	$page->define('DISPLAY',			'');

	return($page->build('admin_maps'));
}


function drawHeaderExtras() {
	return '<script type="text/javascript" language="JavaScript" src="'.PHPRPG_URL.'/lib/js/map.js.php?admin=1"></script>
		<script type="text/javascript" language="JavaScript" src="'.PHPRPG_URL.'/lib/js/scriptload.js"></script>
		<script type="text/javascript" language="JavaScript">
		function doPopup(url,name,x,y,bars) {
			var winArgs = "menubar=0,toolbar=0,resizable=1,statusbar=0,scrollbars="+bars+",width="+x+",height="+y;
			childWindow = window.open(url,name,winArgs);
		}
		</script>';
}


function drawLocationPicker($mapid, $locid) {
	if (empty($_SESSION['PHPRPG']['pick_map']) || empty($_SESSION['PHPRPG']['pick_zyx'])) {
		$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId'], PHPRPG_CHAR_CORE);
		$_SESSION['PHPRPG']['pick_map'] = $objChar->loc['map'];
		$_SESSION['PHPRPG']['pick_zyx'] = MAP::getCoords($objChar->loc['loc'],$_SESSION['PHPRPG']['pick_map']);
		unset($objChar);
	}

	$mapId = $_SESSION['PHPRPG']['pick_map'];
	$arrCoords = $_SESSION['PHPRPG']['pick_zyx'];

	$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);

	$table01 = PHPRPG_DB_PREFIX.'_tiles';
	$table02 = PHPRPG_DB_PREFIX.'_tile_images';

	// MAP SELECT AND DETAILS
	$map_select  = '<select class="input" id="map-select" onChange="loadMap()">';
	$map_select .= '<option value="-1"> - new map - </option>';
	$sql = 'SELECT MapId, MapName
		FROM '.PHPRPG_DB_PREFIX.'_maps
		ORDER BY MapName';
	if (!$dbObj->query($sql)) exit($dbObj->error);
	if ($row = mysql_fetch_array($dbObj->result)) {
		do {
			$map_select .= '<option value="'.$row['MapId'].'"';
			if($row['MapId'] == $mapId) $map_select .= ' selected';
			$map_select .= '>'.$row['MapName'].'</option>';
		} while ($row = mysql_fetch_array($dbObj->result));
	}
	$dbObj->flush();
	$map_select .= '</select>';

	// If we have a map selected in memory (session) then load it's details into $map
	$map = array();
	$map_name = htmlspecialchars(@$map['MapName']);

	// DRAW MAP TABLE
	$map_table = '<table class="map" id="map-table" cellpadding="0" cellspacing="0">';
	for($row=-PHPRPG_PICK_HEIGHT; $row<=PHPRPG_PICK_HEIGHT; $row++) {
		$map_table .= '<tr class="map">';
		for($cell=-PHPRPG_PICK_WIDTH; $cell<=PHPRPG_PICK_WIDTH; $cell++) {
			$action = 'defineLocation(this)';
			$x = $arrCoords['x'] + $cell;
			$y = $arrCoords['y'] + $row;
			$cellid = $x.'|'.$y;
			$celldata = '<img src="'.PHPRPG_URL.'/share/images/default_tile.png" alt="('.$x.','.$y.')" />';
			$map_table .= '<td class="map" id="'.$cellid.'" onclick="'.$action.'">'.$celldata.'</td>';
		}
		$map_table .= '</tr>';
	}
	$map_table .= '</table>';

	$move_dn = 'move(0,-5,0);';
	$move_ne = 'move(5,-5,0);';
	$move_de = 'move(5,0,0);';
	$move_se = 'move(5,5,0);';
	$move_ds = 'move(0,5,0);';
	$move_sw = 'move(-5,5,0);';
	$move_dw = 'move(-5,0,0);';
	$move_nw = 'move(-5,-5,0);';
	$move_du = 'move(0,0,1);';
	$move_dd = 'move(0,0,-1);';

	 // BUILD AND RETURN TILE EDITOR
	$page = new TEMPLATE('page');
	$page->define('MAP_SELECT', $map_select);
	$page->define('MAP_TABLE',  $map_table);
	$page->define('MOVE_DN',    $move_dn);
	$page->define('MOVE_NE',    $move_ne);
	$page->define('MOVE_DE',    $move_de);
	$page->define('MOVE_SE',    $move_se);
	$page->define('MOVE_DS',    $move_ds);
	$page->define('MOVE_SW',    $move_sw);
	$page->define('MOVE_DW',    $move_dw);
	$page->define('MOVE_NW',    $move_nw);
	$page->define('MOVE_DU',    $move_du);
	$page->define('MOVE_DD',    $move_dd);

	return($page->build('loc_pick'));
}
?>
