<?php

if (!defined('PHPRPG_ACTION')) define('PHPRPG_ACTION', true);

require_once(PHPRPG_DIR.'/lib/error.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

class ACTION
{
//PUBLIC:
	var $id;
	var $type;
	var $parent;
	var $hooks;
	var $name;
	var $equiped;
	var $depend;
	var $restrict;
	var $script;

	var $errors;

	function load($actionId=0) {

		$actionId = intval($actionId);

		if ($actionId < 1 && $this->id < 1) return(false);
		if ($actionId < 1 && $this->id > 0) $actionId = $this->id;

		$this->flush();

		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$table = PHPRPG_DB_PREFIX.'_actions';
		$sql  = "SELECT ActionId,ActionHooks,ActionObjTypes,ActionType,ActionParent,ActionEquiped,ActionName,";
		$sql .= "ActionDepend,ActionRestrict,ActionScript FROM $table WHERE ActionId=$actionId";

		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

		list($this->id,
		     $this->hooks,
		     $this->objs,
		     $this->type,
		     $this->parent,
		     $this->equiped,
		     $this->name,
		     $depend,
		     $restrict,
		     $script) = mysql_fetch_row($dbObj->result);

		$dbObj->flush();

		$this->depend   = unserialize(urldecode($depend));
		$this->restrict = unserialize(urldecode($restrict));
		$this->script   = unserialize(urldecode($script));

		if (empty($this->errors)) return(true);
		return(false);
	}

	function save() {

		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);

		$table = PHPRPG_DB_PREFIX.'_actions';

		$depend   = urlencode(serialize($this->depend));
		$restrict = urlencode(serialize($this->restrict));
		$script   = urlencode(serialize($this->script));

		if ($this->id > 0) {

			$sql  = "UPDATE $table SET ";
			$sql .= "ActionScript='$script',ActionType='$this->type',ActionParent='$this->parent',ActionHooks='$this->hooks',";
			$sql .= "ActionName='$this->name',ActionDepend='$depend',ActionRestrict='$restrict',ActionEquiped='$this->equiped' WHERE ActionId='$this->id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		}
		else {
			$sql  = "INSERT INTO $table ";
			$sql .= "( ActionType,ActionParent,ActionHooks,ActionName,ActionDepend,ActionRestrict,ActionEquiped,ActionScript )";
			$sql .= " VALUES ";
			$sql .= "( '$this->type','$this->parent','$this->hooks','$this->name','$depend','$restrict','$this->equiped','$script' )";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

			$this->id = mysql_insert_id();
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function delete($id = 0) {

		if ($this->id > 0 && $id < 1) $id = $this->id;

		if ($id > 0) {
			$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
			$table = PHPRPG_DB_PREFIX.'_actions';
			$sql = "DELETE FROM $table WHERE ActionId='$id'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			return(true);
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

	function flush() {
		$this->id = 0;
		$this->type = 0;
		$this->parent = 0;
		$this->hooks = 0;
		$this->name = '';
		$this->equiped = false;
		$this->depend = array();
		$this->restrict = array();
		$this->script = '';
		$this->errors = NULL;
	}

	function exists($actionId) {

		$actionId = intval($actionId);

		if ($actionId < 1) return(false);

		$rtn = NULL;

		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$table = PHPRPG_DB_PREFIX.'_actions';
		$sql = "SELECT ActionId FROM $table WHERE ActionId='$actionId'";
		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		$rtn = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if (empty($this->errors)) return($rtn['ActionId']);
		return(false);
	}

	function learn($id,$value=0) {

		$id     = intval($id);
		$value  = intval($value);

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();
		$actObj = new ACTION($this->itype,$this->itarg);

		if ( $this->itarg > 0
		 &&  $this->exists($id)
		 &&  $actObj->load($id) ) {

			if (is_array($actObj->depend)) {
				foreach ($actObj->depend as $key=>$value) {
					if (!$actObj->known($key,$value,0)) return(false);
				}
			}

			if (is_array($actObj->restrict)) {
				foreach ($actObj->restrict as $key=>$value) {
					if (!$actObj->known($key,0,$value)) return(false);
				}
			}

			if ($actObj->hooks > 0) $switch = true;
			else $switch = false;

			$table  = PHPRPG_DB_PREFIX.$this->sqlinfo[$this->itype][$switch]['table'];
			$actcol = $this->sqlinfo[$this->itype][$switch]['col'].'ActionId';
			$valcol = $this->sqlinfo[$this->itype][$switch]['col'].'Value';
			$targid = $this->sqlinfo[$this->itype][$switch]['id'];
			$colnfo = $this->sqlinfo[$this->itype][$switch]['col'].$targid;

			if (!$this->known($id)) $sql = "INSERT INTO $table ($actcol,$colnfo,$valcol) VALUES ('$id','$this->itarg','$value')";
			else $sql = "UPDATE $table SET $valcol='$value' WHERE $colnfo='$this->itarg'";
			if (!$dbObj->command($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
			if (empty($this->errors)) return(true);
		}
		return(false);
	}

	function known($id,$min=0,$max=0) {

		$id  = intval($id);
		$min = intval($min);
		$max = intval($max);

		if ($id < 1 && $this->id < 1) return(false);
		if ($id < 1 && $this->id > 0) $id = $this->id;

		$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		$errObj = new ERROR_REPORTER();
		$actObj = new ACTION($this->itype,$this->itarg);
		$actObj->load($id);

		if ($actObj->hooks > 0) $switch = true;
		else $switch = false;

		$table  = PHPRPG_DB_PREFIX.$this->sqlinfo[$this->itype][$switch]['table'];
		$actcol = $this->sqlinfo[$this->itype][$switch]['col'].'ActionId';
		$valcol = $this->sqlinfo[$this->itype][$switch]['col'].'Value';
		$targid = $this->sqlinfo[$this->itype][$switch]['id'];
		$colnfo = $this->sqlinfo[$this->itype][$switch]['col'].$targid;

		$sql = "SELECT $actcol,$valcol FROM $table WHERE $colnfo='$this->itarg' AND $actcol='$id'";

		if (!$dbObj->query($sql)) $this->errors[] = $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
		$row = mysql_fetch_assoc($dbObj->result);
		$dbObj->flush();

		if ( empty($row["$actcol"])
		|| ($min > 0 && $row["$valcol"] < $min)
		|| ($max > 0 && $row["$valcol"] > $max)) {
			return(false);
		}
		if (empty($this->errors)) return(true);
		return(false);
	}

//PRIVATE:
	var $sqlinfo;
	var $itype;
	var $itarg;

	function ACTION($target,$class) {
		$this->itype = intval($class);
		$this->itarg = intval($target);
		$this->flush();
		$this->sqlinfo[PHPRPG_CLASS_CHAR][true]     = array('table'=>'_char_action_passive', 'col'=>'CharPas',    'id'=>'CharId');
		$this->sqlinfo[PHPRPG_CLASS_CHAR][false]    = array('table'=>'_char_action_active',  'col'=>'CharAct',    'id'=>'CharId');
		$this->sqlinfo[PHPRPG_CLASS_ITEM][false]    = array('table'=>'_item_action',         'col'=>'ItemAct',    'id'=>'ItemId');
		$this->sqlinfo[PHPRPG_CLASS_TILE][false]    = array('table'=>'_tile_action',         'col'=>'TileAct',    'id'=>'TileId');
		$this->sqlinfo[PHPRPG_CLASS_TERRAIN][false] = array('table'=>'_tile_terrain_action', 'col'=>'TerrainAct', 'id'=>'TerrainId');
	}
}


?>