<?php

// Do standard require_onces
require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/mysql.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_ITEM);

// Main logic of the application
switch (@$_REQUEST['submit']) {

default:

	require_once(PHPRPG_DIR.'/lib/admin/item/item_editor.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawItemEditor());

case 'Search':

	require_once(PHPRPG_DIR.'/lib/admin/item/search_results.php');
	require_once(PHPRPG_DIR.'/lib/context.lib.php');

	exit(drawSearchResults($_GET['query-string']));

case 'Organize Images Icon':

	require_once(PHPRPG_DIR.'/lib/admin/item/image_set_editor.php');

	exit(drawImageEditor($_GET['image-id'],
	                     $_GET['image-set'],
	                     $_GET['action'],
	                     $_GET['item-id'],
	                     $_GET['old-image-id'],
	                     'icon'));

case 'Organize Images Merg':

	require_once(PHPRPG_DIR.'/lib/admin/item/image_set_editor.php');

	exit(drawImageEditor($_GET['image-id'],
	                     $_GET['image-set'],
	                     $_GET['action'],
	                     $_GET['item-id'],
	                     $_GET['old-image-id'],
	                     'merg'	));

case 'Script Select':

	require_once(PHPRPG_DIR.'/lib/admin/item/script_selector.php');

	exit(drawScriptSelector($_GET['item-id'],
	                        $_GET['item-event']));

case 'Scan Icon':

	require_once(PHPRPG_DIR.'/lib/admin/item/image_scan.php');

	exit(drawItemScan(true));

case 'Scan Merg':

	require_once(PHPRPG_DIR.'/lib/admin/item/image_scan.php');

	exit(drawItemScan(false));

case 'Edit Attributes':

	require_once(PHPRPG_DIR.'/lib/admin/item/attribute_editor.php');

	exit(drawAttributeEditor($_GET['item-id'],
	                         $_GET['action'],
	                         $_GET['attrib-key'],
	                         $_GET['attrib-value'],
	                         $_GET['attrib-key-old']));

case 'Add Images':

	// See if $add_entries exists and if so try to add them to database
	$addEntries = @$_POST['add_entries'];
	$type       = @$_POST['type'];
	if (@$addEntries) {
		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		foreach ($addEntries as $value) {
			$tablename = PHPRPG_DB_PREFIX.'_item_images';
			$query = "INSERT INTO $tablename (ItemImagePath,ItemImageType) VALUES ('$value','$type')";
			if (!$dbObj->command($query)) die($dbObj->error);
		}
		$dbObj->flush();
	}

	$type_name = ($type) ? 'Icon' : 'Merg';

	exit(header("location: ".PHPRPG_URL."/items.php?submit=Scan+$type_name"));

case 'Del Images':

	// See if $del_entries exists and if so try to remove them from the database
	$remEntries = @$_POST['rem_entries'];
	$type       = @$_POST['type'];
	if (@$remEntries) {
		$dbObj = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
		foreach ($remEntries as $value) {
			$tablename = PHPRPG_DB_PREFIX.'_item_images';
			$query = "DELETE FROM $tablename WHERE ItemImagePath='$value' && ItemImageType='$type'";
			if (!$dbObj->command($query)) die($dbObj->error);
		}
		$dbObj->flush();
	}

	$type_name = ($type) ? 'Icon' : 'Merg';

	exit(header("location: ".PHPRPG_URL."/items.php?submit=Scan+$type_name"));

case 'Upload Image Icon':

	require_once(PHPRPG_DIR.'/lib/admin/item/image_uploader.php');

	exit(UploadImages(@$_POST['action'],true));

case 'Upload Image Merg':

	require_once(PHPRPG_DIR.'/lib/admin/item/image_uploader.php');

	exit(UploadImages(@$_POST['action'],false));
}


?>