<?php

// Include common configuration file
require_once(PHPRPG_DIR.'/etc/db.conf.php');
require_once(PHPRPG_DIR.'/etc/map.conf.php');
require_once(PHPRPG_DIR.'/etc/local.conf.php');
require_once(PHPRPG_DIR.'/lib/system.lib.php');

// Include common required libraries
require_once(PHPRPG_DIR.'/lib/error.lib.php');

// Error reporting level
error_reporting(E_ALL);

// System Variables
$BASE_VER = '0.8.0';

// Internal Image Paths
define('PHPRPG_CORE_IMG', PHPRPG_URL.'/share/images');
define('PHPRPG_TMPL_IMG', PHPRPG_URL.'/share/templates/'.PHPRPG_THEME.'/images');
define('PHPRPG_TMP_DIR',  PHPRPG_DIR.'/tmp');
define('PHPRPG_TMP_URL',  PHPRPG_URL.'/tmp');

// Internal Object Identifiers
define('PHPRPG_CLASS_CHAR',      1);
define('PHPRPG_CLASS_USER',      2);
define('PHPRPG_CLASS_TILE',      4);
define('PHPRPG_CLASS_TERRAIN',   8);
define('PHPRPG_CLASS_ITEM',     16);
define('PHPRPG_CLASS_SKILL',    32);
define('PHPRPG_CLASS_SPELL',    64);
define('PHPRPG_CLASS_MAP',     128);

// Internal Event Identifiers
define('PHPRPG_EVENT_CREATE',      1);
define('PHPRPG_EVENT_DESTROY',     2);
define('PHPRPG_EVENT_PICKUP',      4);
define('PHPRPG_EVENT_DROP',        8);
define('PHPRPG_EVENT_ATTACK',     16);
define('PHPRPG_EVENT_DEFEND',     32);
define('PHPRPG_EVENT_EQUIP',      64);
define('PHPRPG_EVENT_UNEQUIP',   128);
define('PHPRPG_EVENT_ENTER',     256);
define('PHPRPG_EVENT_LEAVE',     512);
define('PHPRPG_EVENT_USE',      1024);
define('PHPRPG_EVENT_TALK',     2048);

// Start Sessions; ready or not!!
session_save_path(PHPRPG_TMP_DIR);
session_start();

// Do system upkeep
$systemObj = new SYSTEM();
$systemObj->StaminaUpkeep();
$systemObj->ManaUpkeep();
$systemObj->HPUpkeep();


?>