<?php

require_once('./etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/display.lib.php');
require_once(PHPRPG_DIR.'/lib/template.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');
require_once(PHPRPG_DIR.'/lib/context.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
if(!$authObj->userCheck()) $authObj->login();

// Main logic of the application
switch (@$_REQUEST['submit']) {

default:
	// DRAW HEADER INFORMATION
	$page  = new TEMPLATE('page');
	$olObj = new Overlib(PHPRPG_URL.'/lib/js');
	$context_header = $olObj->init();

	$header_extras  = '<script type="text/javascript" language="JavaScript">';
	$header_extras .= '</script>';

	$url = PHPRPG_URL."/create-character.php?submit=Draw+Portrait";
	$portrait_link  = '<a href="'.$url.'" id="create-portrait-link" name="create-portrait-link">Select Portrait</a>';

	$url = PHPRPG_URL."/create-character.php?submit=Draw+Statistics";
	$stats_link  = '<a href="'.$url.'" id="create-stats-link" name="create-stats-link">Select Statistics</a>';

	$url = PHPRPG_URL."/create-character.php?submit=Draw+Customization";
	$custom_link  = '<a href="'.$url.'" id="create-cust-link" name="create-cust-link">Select Customizations</a>';

	$url = PHPRPG_URL."/create-character.php?submit=Create+Character";
	$create_link  = '<a href="'.$url.'" id="create-create-link" name="create-create-link">Create Character</a>';

	$page->define('TITLE',                 'Character Creator');
	$page->define('HEADER_EXTRAS',         $header_extras);
	$page->define('PROGRAM_NAME',          'Character Creator :: Main Menu');
	$page->define('CONTEXT_HEADER',        $context_header);
	$page->define('ERROR',                 '');
	$page->define('PORTRAIT_LINK',         $portrait_link);
	$page->define('STATS_LINK',            $stats_link);
	$page->define('CUSTOM_LINK',           $custom_link);
	$page->define('CREATE_LINK',           $create_link);

	exit($page->build('create_character'));


case 'Draw Portrait':

	require_once(PHPRPG_DIR.'/lib/mysql.lib.php');

	$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
	$errObj = new ERROR_REPORTER();

	// DRAW HEADER INFORMATION
	$page  = new TEMPLATE('page');
	$olObj = new Overlib(PHPRPG_URL.'/lib/js');
	$context_header = $olObj->init();

	$header_extras  = '<script type="text/javascript" language="JavaScript">';
	$header_extras .= '</script>';

	$url = PHPRPG_URL."/create-character.php?submit=Set+Portrait";
	$portrait_div = '<div id="create-portrait-div" name="create-portrait-div">';
	$current_id   = @$_SESSION['PHPRPG']['CHAR_CREATE']['PORTRAIT'];
	$current_image = "";

	$tablename = PHPRPG_DB_PREFIX.'_char_images';
	$query  = "SELECT CharImageId, CharImagePath ";
	$query .= "FROM $tablename ";
	$query .= "WHERE CharImageType='portrait'";

	if (!$dbObj->query($query)) $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);

	while ($row = mysql_fetch_assoc($dbObj->result)) {
		$url = PHPRPG_URL."/create-character.php?submit=Set+Portrait&create-portrait-id=".$row['CharImageId'];
		$portrait_div .= '<a href="'.$url.'"><img src="'.PHPRPG_URL."/".$row['CharImagePath'].'"></a>&nbsp;';

		if ($current_id == $row['CharImageId'])
			$current_image = '<img src="'.PHPRPG_URL.'/'.$row['CharImagePath'].'">';
	}

	$portrait_div .= '</div>';

	$page->define('TITLE',                 'Character Creator');
	$page->define('HEADER_EXTRAS',         $header_extras);
	$page->define('PROGRAM_NAME',          'Character Creator :: Select Portrait');
	$page->define('CONTEXT_HEADER',        $context_header);
	$page->define('ERROR',                 '');
	$page->define('PORTAIT_DIV',           $portrait_div);
	$page->define('CURRENT_PORTRAIT',      $current_image);

	exit($page->build('create_character_portrait'));


case 'Draw Statistics':

	// DRAW HEADER INFORMATION
	$page  = new TEMPLATE('page');
	$olObj = new Overlib(PHPRPG_URL.'/lib/js');
	$context_header = $olObj->init();

	$create_stat_total = PHPRPG_START_STATS;
	if ($create_stat_total < 1) $create_stat_total = 0;

	$create_size_0 = '';
	$create_size_1 = '';
	$create_size_2 = '';
	$create_size_3 = '';
	$create_size_4 = '';
	$create_size_5 = '';
	$create_size_6 = '';

	switch(@$_SESSION['PHPRPG']['CHAR_CREATE']['SIZE']) {
	case 0:  $create_size_0 = 'selected'; break;
	case 1:  $create_size_1 = 'selected'; break;
	case 2:  $create_size_2 = 'selected'; break;
	case 3:  $create_size_3 = 'selected'; break;
	case 4:  $create_size_4 = 'selected'; break;
	case 5:  $create_size_5 = 'selected'; break;
	case 6:  $create_size_6 = 'selected'; break;
	}


	$header_extras  = "<script type='text/javascript' language='JavaScript'> \n";
	$header_extras .= "function  saveStats() { \n";
	$header_extras .= "	var str   = Number (document.getElementById('char-str-input').value); \n";
	$header_extras .= "	var vit   = Number (document.getElementById('char-vit-input').value); \n";
	$header_extras .= "	var agl   = Number (document.getElementById('char-agl-input').value); \n";
	$header_extras .= "	var inte  = Number (document.getElementById('char-int-input').value); \n";
	$header_extras .= "	var wis   = Number (document.getElementById('char-wis-input').value); \n";
	$header_extras .= "	var char  = Number (document.getElementById('char-chr-input').value); \n";
	$header_extras .= "	var age   = Number (document.getElementById('char-age-input').value); \n";
	$header_extras .= "	var name  = document.getElementById('char-name-input').value; \n";
	$header_extras .= "	var size  = document.getElementById('create-size-select').value; \n";
	$header_extras .= "	var total = (str+vit+agl+inte+wis+char); \n";
	$header_extras .= "	if (total > ".$create_stat_total.") alert('You have allicated too many points!'); \n";
	$header_extras .= "	if (total < ".$create_stat_total.") alert('You have not allicated all your points!'); \n";
	$header_extras .= "	else { \n";
	$header_extras .= "    url = '".PHPRPG_URL."/create-character.php?submit=Set+Stats&char-str-input='+str+'&char-vit-input='+vit+'&char-agl-input='+agl+'&char-int-input='+inte+'&char-wis-input='+wis+'&char-chr-input='+char+'&char-name-input='+name+'&char-age-input='+age+'&create-size-select='+size; \n";
	$header_extras .= "    window.location=url; \n";
	$header_extras .= "	} \n";
	$header_extras .= "} \n";
	$header_extras .= "</script> \n";

	$form_header = '<form method="POST"  id="create-stats-form" name="create-stats-form">';

	$create_name_input = "<input type='text' class='input' id='char-name-input'  name='char-name-input' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['NAME']."'>";
	$create_age_input  = "<input type='text' class='input' id='char-age-input'   name='char-age-input'  size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['AGE']."'>";
	$create_str_input = "<input type='text' class='input' id='char-str-input'  name='char-str-input' size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['STR']."'>";
	$create_vit_input = "<input type='text' class='input' id='char-vit-input'  name='char-vit-input' size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['VIT']."'>";
	$create_agl_input = "<input type='text' class='input' id='char-agl-input'  name='char-agl-input' size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['AGL']."'>";
	$create_int_input = "<input type='text' class='input' id='char-int-input'  name='char-int-input' size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['INT']."'>";
	$create_wis_input = "<input type='text' class='input' id='char-wis-input'  name='char-wis-input' size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['WIS']."'>";
	$create_chr_input = "<input type='text' class='input' id='char-chr-input'  name='char-chr-input' size='3' value='".@$_SESSION['PHPRPG']['CHAR_CREATE']['CHR']."'>";

	$javascript = "onChange='return formChange()'";
	$create_size_select  = "<select class='input' id='create-size-select' name='create-size-select' $javascript>";
	$create_size_select .= "<option value='0' $create_size_0>Microscopic</option>";
	$create_size_select .= "<option value='1' $create_size_1>Tiny</option>";
	$create_size_select .= "<option value='2' $create_size_2>Small</option>";
	$create_size_select .= "<option value='3' $create_size_3>Normal</option>";
	$create_size_select .= "<option value='4' $create_size_4>Large</option>";
	$create_size_select .= "<option value='5' $create_size_5>Huge</option>";
	$create_size_select .= "<option value='6' $create_size_6>Gigantic</option>";
	$create_size_select .= "</select>";

	$context = $olObj->over('Save the current layout.', 'Save');
	$javascript = "onClick='saveStats()'";
	$create_save_button = "<input type='button' class='inputbutton' id='char-save-button' value='Save' $context $javascript>";

	$page->define('TITLE',                 'Character Creator');
	$page->define('HEADER_EXTRAS',         $header_extras);
	$page->define('PROGRAM_NAME',          'Character Creator :: Select Statistics');
	$page->define('CONTEXT_HEADER',        $context_header);
	$page->define('ERROR',                 '');
	$page->define('FORM_HEADER',           $form_header);
	$page->define('STAT_LIMIT',            $create_stat_total);
	$page->define('STAT_STR',              $create_str_input);
	$page->define('STAT_VIT',              $create_vit_input);
	$page->define('STAT_AGL',              $create_agl_input);
	$page->define('STAT_INT',              $create_int_input);
	$page->define('STAT_WIS',              $create_wis_input);
	$page->define('STAT_CHR',              $create_chr_input);
	$page->define('STAT_NAME',             $create_name_input);
	$page->define('STAT_AGE',              $create_age_input);
	$page->define('STAT_SIZE',             $create_size_select);
	$page->define('STAT_SAVE',             $create_save_button);

	exit($page->build('create_character_stats'));


case "Draw Customization":

	$select_1 = "";
	$select_2 = "";
	$select_3 = "";
	$select_4 = "";
	$select_5 = "";

	$select_type = @$_SESSION['PHPRPG']['CHAR_CREATE']['SELECT_TYPE'];

	switch($select_type)
	{
	case '2':
		$select_2    = "selected";
		$type_select = 'BODY';
		break;
	case '3':
		$select_3    = "selected";
		$type_select = 'HAIR';
		break;
	case '4':
		$select_4    = "selected";
		$type_select = 'WINGS';
		break;
	case '5':
		$select_5    = "selected";
		$type_select = 'TAIL';
		break;
	default:
		$select_1        = "selected";
		$type_select     = "";
		$create_pf_red   = "";
		$create_pf_green = "";
		$create_pf_blue  = "";
		$create_hf_red   = "";
		$create_hf_green = "";
		$create_hf_blue  = "";
		break;
	}

	if ($type_select) {
		if (@$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_RED'] == "")
			$create_pf_red  = 255;
		else $create_pf_red = @$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_RED'];
		$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_RED'] = $create_pf_red;

		if (@$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_GREEN'] == "")
			$create_pf_green  = 255;
		else $create_pf_green = @$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_GREEN'];
		$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_GREEN'] = $create_pf_green;

		if (@$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_BLUE'] == "")
			$create_pf_blue  = 255;
		else $create_pf_blue = @$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_BLUE'];
		$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['PF_BLUE'] = $create_pf_blue;

		if (@$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_RED'] == "")
			$create_hf_red  = 128;
		else $create_hf_red = @$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_RED'];
		$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_RED'] = $create_hf_red;

		if (@$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_GREEN'] == "")
			$create_hf_green  = 128;
		else $create_hf_green = @$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_GREEN'];
		$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_GREEN'] = $create_hf_green;

		if (@$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_BLUE'] == "")
			$create_hf_blue  = 128;
		else $create_hf_blue = @$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_BLUE'];
		$_SESSION['PHPRPG']['CHAR_CREATE'][$type_select]['HF_BLUE'] = $create_hf_blue;
	}

	if (empty($_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['IMAGE']))

	require_once(PHPRPG_DIR.'/lib/sprite.lib.php');
	$spriteObj = new SPRITE();
	$spriteObj->sprite_dir = PHPRPG_DIR.'/tmp/char-create-'.$_SESSION['PHPRPG']['UserId'].'.png';
	$spriteObj->sprite_url = PHPRPG_URL.'/tmp/char-create-'.$_SESSION['PHPRPG']['UserId'].'.png';

	 if (!empty($_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['IMAGE'])) {
		$spriteObj->body       = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['IMAGE'];
		$spriteObj->body_pf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['PF_RED'];
		$spriteObj->body_pf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['PF_GREEN'];
		$spriteObj->body_pf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['PF_BLUE'];
		$spriteObj->body_hf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['HF_RED'];
		$spriteObj->body_hf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['HF_GREEN'];
		$spriteObj->body_hf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['BODY']['HF_BLUE'];
	}

	$spriteObj->hair       = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['IMAGE'];
	$spriteObj->hair_pf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['PF_RED'];
	$spriteObj->hair_pf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['PF_GREEN'];
	$spriteObj->hair_pf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['PF_BLUE'];
	$spriteObj->hair_hf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['HF_RED'];
	$spriteObj->hair_hf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['HF_GREEN'];
	$spriteObj->hair_hf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['HAIR']['HF_BLUE'];
	$spriteObj->wings       = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['IMAGE'];
	$spriteObj->wings_pf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['PF_RED'];
	$spriteObj->wings_pf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['PF_GREEN'];
	$spriteObj->wings_pf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['PF_BLUE'];
	$spriteObj->wings_hf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['HF_RED'];
	$spriteObj->wings_hf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['HF_GREEN'];
	$spriteObj->wings_hf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['WINGS']['HF_BLUE'];
	$spriteObj->tail       = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['IMAGE'];
	$spriteObj->tail_pf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['PF_RED'];
	$spriteObj->tail_pf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['PF_GREEN'];
	$spriteObj->tail_pf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['PF_BLUE'];
	$spriteObj->tail_hf[0] = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['HF_RED'];
	$spriteObj->tail_hf[1] = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['HF_GREEN'];
	$spriteObj->tail_hf[2] = @$_SESSION['PHPRPG']['CHAR_CREATE']['TAIL']['HF_BLUE'];
	$spriteObj->write();

	$page = new TEMPLATE('page');
	$olObj = new Overlib(PHPRPG_URL.'/lib/js');
	$context_header = $olObj->init();

	$header_extras  = "<script type='text/javascript' language='JavaScript'> \n";
	$header_extras .= "function doPreview(change) { \n";
	$header_extras .= "  var select_type = Number (document.getElementById('create-bodytype-select').value); \n";
	$header_extras .= "  if (change == 1) {\n";
	$header_extras .= "    var pf_red      = Number (document.getElementById('create-pf-red').  value); \n";
	$header_extras .= "    var pf_green    = Number (document.getElementById('create-pf-green').value); \n";
	$header_extras .= "    var pf_blue     = Number (document.getElementById('create-pf-blue') .value); \n";
	$header_extras .= "    var hf_red      = Number (document.getElementById('create-hf-red').  value); \n";
	$header_extras .= "    var hf_green    = Number (document.getElementById('create-hf-green').value); \n";
	$header_extras .= "    var hf_blue     = Number (document.getElementById('create-hf-blue'). value); \n";
	$header_extras .= "    url = '".PHPRPG_URL."/create-character.php?submit=Preview+Customization&create-bodytype-select='+select_type+'&create-pf-red='+pf_red+'&create-pf-green='+pf_green+'&create-pf-blue='+pf_blue+'&create-hf-red='+hf_red+'&create-hf-green='+hf_green+'&create-hf-blue='+hf_blue; \n";
	$header_extras .= "    window.location=url; \n";
	$header_extras .= "  } \n";
	$header_extras .= "  if (change == 2) { \n";
	$header_extras .= "    url = '".PHPRPG_URL."/create-character.php?submit=Preview+Customization&create-bodytype-select='+select_type+'&change=true'; \n";
	$header_extras .= "    window.location=url; \n";
	$header_extras .= "  } \n";
	$header_extras .= "  if (change == 3) { \n";
	$header_extras .= "  	url = '".PHPRPG_URL."/create-character.php?' \n";
	$header_extras .= "     window.location=url; \n";
	$header_extras .= "  } \n";
	$header_extras .= "} \n";
	$header_extras .= '</script>';

	$form_header = '<form method="POST"  id="create-customize-form" name="create-stats-form">';

	$char_sprite = "<img width='128' height=128' src='".$spriteObj->sprite_url."'>";

	$char_part_overflow = "";

	$repository = GetSpriteImages($type_select);
	if (!empty($repository)) {
		$char_part_overflow = '';
		foreach($repository as $image) {
			$image_path = "<img src='".PHPRPG_URL."/$image'>";
			$url = PHPRPG_URL."/create-character.php?submit=Preview+Customization&create-bodytype-select=$select_type&create-image-change=1&create-image=$image";
			$char_part_overflow .= "<a href='$url'>$image_path</a>";
		}
	}

	if ($type_select && empty($repository)) $char_part_overflow = 'No Images To Select.';

	$javascript = "onChange='return doPreview(2)'";
	$char_body_pulldown  = "<select class='input' id='create-bodytype-select' name='create-bodytype-select' $javascript>";
	$char_body_pulldown .= "<option value='1' $select_1>Select Parts</option>";
	$char_body_pulldown .= "<option value='2' $select_2>Body</option>";
	$char_body_pulldown .= "<option value='3' $select_3>Hair</option>";
	$char_body_pulldown .= "<option value='4' $select_4>Wings</option>";
	$char_body_pulldown .= "<option value='5' $select_5>Tail</option>";
	$char_body_pulldown .= "</select>";

	$char_input_pf_red   = "<input type='text' id='create-pf-red'    name='create-pf-red'   class='input' size='4' value='$create_pf_red'>";
	$char_input_pf_green = "<input type='text' id='create-pf-green'  name='create-pf-green' class='input' size='4' value='$create_pf_green'>";
	$char_input_pf_blue  = "<input type='text' id='create-pf-blue'   name='create-pf-blue'  class='input' size='4' value='$create_pf_blue'>";
	$char_input_hf_red   = "<input type='text' id='create-hf-red'    name='create-hf-red'   class='input' size='4' value='$create_hf_red'>";
	$char_input_hf_green = "<input type='text' id='create-hf-green'  name='create-hf-green' class='input' size='4' value='$create_hf_green'>";
	$char_input_hf_blue  = "<input type='text' id='create-hf-blue'   name='create-hf-blue'  class='input' size='4' value='$create_hf_blue'>";

	$javascript = "onClick='return doPreview(1)'";
	$char_button_preview = "<input type='button' id='create-preview' name='create-preview' class='inputbutton' value='Preview' $javascript>";

	$javascript = "onClick='return doPreview(3)'";
	$char_button_save = "<input type='button' id='create-save' name='create-save' class='inputbutton' value='Save Scheme' $javascript>";

	$page->define('HEADER_EXTRAS',       $header_extras);
	$page->define('FORM_HEADER',         $form_header);
	$page->define('PROGRAM_NAME',        'Character Creator :: Customize');
	$page->define('CONTEXT_HEADER',      $context_header);
	$page->define('TITLE',               'Character Creator');
	$page->define('CHAR_SPRITE',         $char_sprite);
	$page->define('CHAR_BODY_PULLDOWN',  $char_body_pulldown);
	$page->define('CHAR_PART_OVERFLOW',  $char_part_overflow);
	$page->define('CHAR_INPUT_PF_RED',   $char_input_pf_red);
	$page->define('CHAR_INPUT_PF_GREEN', $char_input_pf_green);
	$page->define('CHAR_INPUT_PF_BLUE',  $char_input_pf_blue);
	$page->define('CHAR_INPUT_HF_RED',   $char_input_hf_red);
	$page->define('CHAR_INPUT_HF_GREEN', $char_input_hf_green);
	$page->define('CHAR_INPUT_HF_BLUE',  $char_input_hf_blue);
	$page->define('CHAR_BUTTON_PREVIEW', $char_button_preview);
	$page->define('CHAR_BUTTON_SAVE',    $char_button_save);

	exit($page->build('create_character_customizations'));


case 'Preview Customization':

	$select_type    = @$_REQUEST['create-bodytype-select'];
	$input_pf_red   = @$_REQUEST['create-pf-red'];
	$input_pf_green = @$_REQUEST['create-pf-green'];
	$input_pf_blue  = @$_REQUEST['create-pf-blue'];
	$input_hf_red   = @$_REQUEST['create-hf-red'];
	$input_hf_green = @$_REQUEST['create-hf-green'];
	$input_hf_blue  = @$_REQUEST['create-hf-blue'];
	$image_path     = @$_REQUEST['create-image'];
	$image_change   = @$_REQUEST['create-image-change'];

	$_SESSION['PHPRPG']['CHAR_CREATE']['SELECT_TYPE'] = $select_type;

	switch($select_type)
	{
	case '2': $select_type = 'BODY'; break;
	case '3': $select_type = 'HAIR'; break;
	case '4': $select_type = 'WINGS'; break;
	case '5': $select_type = 'TAIL'; break;
	default : $select_type = ''; break;
	}

	if (!empty($_REQUEST['change']))
		exit(header("location: ".PHPRPG_URL."/create-character.php?submit=Draw+Customization"));

	if ($image_change) {
		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['IMAGE'] = $image_path;
		exit(header("location: ".PHPRPG_URL."/create-character.php?submit=Draw+Customization"));
	}

	if ($select_type) {
		if ($input_pf_red > 255)   $input_pf_red   = 255;
		if ($input_pf_red < 0)     $input_pf_red   = 0;
		if ($input_pf_green > 255) $Input_pf_green = 255;
		if ($input_pf_green < 0)   $input_pf_green = 0;
		if ($input_pf_blue > 255)  $Input_pf_blue  = 255;
		if ($input_pf_blue < 0)    $input_pf_blue  = 0;

		if ($input_hf_red > 255)   $input_hf_red   = 255;
		if ($input_hf_red < 0)     $input_hf_red   = 0;
		if ($input_hf_green > 255) $Input_hf_green = 255;
		if ($input_hf_green < 0)   $input_hf_green = 0;
		if ($input_hf_blue > 255)  $Input_hf_blue  = 255;
		if ($input_hf_blue < 0)    $input_hf_blue  = 0;

		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['PF_RED']   = $input_pf_red;
		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['PF_GREEN'] = $input_pf_green;
		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['PF_BLUE']  = $input_pf_blue;
		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['HF_RED']   = $input_hf_red;
		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['HF_GREEN'] = $input_hf_green;
		$_SESSION['PHPRPG']['CHAR_CREATE'][$select_type]['HF_BLUE']  = $input_hf_blue;
	}

	exit(header("location: ".PHPRPG_URL."/create-character.php?submit=Draw+Customization"));


case 'Set Portrait':
	$_SESSION['PHPRPG']['CHAR_CREATE']['PORTRAIT'] = $_REQUEST['create-portrait-id'];
	exit(header("location: ".PHPRPG_URL."/create-character.php"));


case 'Set Stats':
	$str = @$_REQUEST['char-str-input'];
	$vit = @$_REQUEST['char-vit-input'];
	$agl = @$_REQUEST['char-agl-input'];
	$int = @$_REQUEST['char-int-input'];
	$wis = @$_REQUEST['char-wis-input'];
	$chr = @$_REQUEST['char-chr-input'];
	$total = $str+$vit+$agl+$int+$wis+$chr;

	$_SESSION['PHPRPG']['CHAR_CREATE']['NAME'] = @$_REQUEST['char-name-input'];
	$_SESSION['PHPRPG']['CHAR_CREATE']['AGE']  = @$_REQUEST['char-age-input'];
	$_SESSION['PHPRPG']['CHAR_CREATE']['SIZE'] = @$_REQUEST['create-size-select'];

	if ($total > PHPRPG_START_STATS) {
		header("location: ".PHPRPG_URL."/create-character.php");
	}
	else {
		$_SESSION['PHPRPG']['CHAR_CREATE']['STR'] = $str;
		$_SESSION['PHPRPG']['CHAR_CREATE']['VIT'] = $vit;
		$_SESSION['PHPRPG']['CHAR_CREATE']['AGL'] = $agl;
		$_SESSION['PHPRPG']['CHAR_CREATE']['INT'] = $int;
		$_SESSION['PHPRPG']['CHAR_CREATE']['WIS'] = $wis;
		$_SESSION['PHPRPG']['CHAR_CREATE']['CHR'] = $chr;
		header("location: ".PHPRPG_URL."/create-character.php");
	}
	exit();


case 'Create Character':

	$data = @$_SESSION['PHPRPG']['CHAR_CREATE'];

	$charObj = new CHARACTER();
	$charObj->user = $_SESSION['PHPRPG']['UserId'];
	$charObj->name = $data['NAME'];

	if ($charObj->name == '')
	{
		AlertPlayer("You did not select a name for this character!");
		break;
	}

	$charObj->size         = $data['SIZE'];
	$charObj->sprite->body = SPRITE::GetImageId($data['BODY']['IMAGE']);

	if ($charObj->sprite->body < 1)
	{
		AlertPlayer("You did not select a valid body for this character.");
		break;
	}

	$charObj->sprite->body_pf  = array($data['BODY']['PF_RED'],$data['BODY']['PF_GREEN'],$data['BODY']['PF_BLUE']);
	$charObj->sprite->body_hf  = array($data['BODY']['HF_RED'],$data['BODY']['HF_GREEN'],$data['BODY']['HF_BLUE']);
	$charObj->sprite->hair     = SPRITE::GetImageId($data['HAIR']['IMAGE']);
	$charObj->sprite->hair_pf  = array($data['HAIR']['PF_RED'],$data['HAIR']['PF_GREEN'],$data['HAIR']['PF_BLUE']);
	$charObj->sprite->hair_hf  = array($data['HAIR']['HF_RED'],$data['HAIR']['HF_GREEN'],$data['HAIR']['HF_BLUE']);
	$charObj->sprite->tail     = SPRITE::GetImageId($data['TAIL']['IMAGE']);
	$charObj->sprite->tail_pf  = array($data['TAIL']['PF_RED'],$data['TAIL']['PF_GREEN'],$data['TAIL']['PF_BLUE']);
	$charObj->sprite->tail_hf  = array($data['TAIL']['HF_RED'],$data['TAIL']['HF_GREEN'],$data['TAIL']['HF_BLUE']);
	$charObj->sprite->wings    = SPRITE::GetImageId($data['WINGS']['IMAGE']);
	$charObj->sprite->wings_pf = array($data['WINGS']['PF_RED'],$data['WINGS']['PF_GREEN'],$data['WINGS']['PF_BLUE']);
	$charObj->sprite->wings_hf = array($data['WINGS']['HF_RED'],$data['WINGS']['HF_GREEN'],$data['WINGS']['HF_BLUE']);
	$charObj->sprite->portrait = $data['PORTRAIT'];
	$charObj->stats    = array('Str'=>$data['STR'],'Vit'=>$data['VIT'],'Agl'=>$data['AGL'],'Chr'=>$data['CHR'],'Int'=>$data['INT'],'Wis'=>$data['WIS'],'Krm'=>0,'Age'=>$data['AGE'] );
	$charObj->hp       = array('cur'=>$data['VIT'],'max'=>$data['VIT']);
	$charObj->stm      = array('cur'=>PHPRPG_START_STAMINA,'max'=>PHPRPG_START_STAMINA);
	$charObj->cap      = array('cur'=>$data['STR'],'max'=>$data['STR']);
	$charObj->mana     = array('cur'=>$data['INT'],'max'=>$data['INT']);
	$charObj->ac       = PHPRPG_START_AC;
	$charObj->loc      = array('map'=>PHPRPG_START_MAP,'loc'=>PHPRPG_START_LOC);
	$charObj->size     = PHPRPG_START_SIZE;
	$charObj->currency = PHPRPG_START_GP;
	$charObj->save();

	unset($_SESSION['PHPRPG']['CHAR_CREATE']);

	exit(header("location: ".PHPRPG_URL."/index.php"));
}


function GetSpriteImages($type='body') {

	if ($type == '') return;

	$dbObj  = new MYSQL(PHPRPG_DB_HOST,PHPRPG_DB_USER,PHPRPG_DB_PASS,PHPRPG_DB_NAME);
	$errObj = new ERROR_REPORTER();

	$table = PHPRPG_DB_PREFIX.'_char_images';
	$sql   = "SELECT CharImagePath FROM $table WHERE CharImageType='".strtolower($type)."'";
	if (!($dbObj->query($sql))) $errObj->report(PHPRPG_ERR_ERROR, $dbObj->error, __FILE__, __LINE__);
	while ($row = mysql_fetch_assoc($dbObj->result)) $rtn[] = $row['CharImagePath'];

	if (!empty($rtn)) return $rtn;
}


function AlertPlayer($text='') {
	echo "<script type='text/javascript' language='JavaScript'> \n";
	echo "    confirm('$text'); \n";
	echo "    window.location='".PHPRPG_URL."/create-character.php'; \n";
	echo "</script> \n";
}

?>