<?php

require_once('../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');

header('Content-type: text/javascript');

$z = intval(@$_REQUEST['z']);
$y = intval(@$_REQUEST['y']);
$x = intval(@$_REQUEST['x']);

$objAuth = new AUTHENTICATE();

// Check if user has logged in
if ($objAuth->userCheck() === false) exit;

unset($objAuth);

$options   = PHPRPG_CHAR_CORE + PHPRPG_CHAR_STATS;
$objChar   = new CHARACTER($_SESSION['PHPRPG']['CharId'], $options);
$objMap    = new MAP($objChar->loc['map']);
$arrCoords = $objMap->getCoords($objChar->loc['loc']);

// If no admin privs, stop them from moving too far
if ($_SESSION['PHPRPG']['UserLevel'] <= PHPRPG_AUTH_NONE) {
	$z = max(-1,min(1,$z));
	$y = max(-1,min(1,$y));
	$x = max(-1,min(1,$x));
}


@$arrCoords['z'] += $z;
if ($objMap->wrapZ) $arrCoords['z'] = $objMap->wrapCoord($arrCoords['z'], $objMap->sizeZ);
elseif ($objMap->sizeZ) $arrCoords['z'] = max(0,min($objMap->sizeZ-1,$arrCoords['z']));
@$arrCoords['y'] += $y;
if ($objMap->wrapY) $arrCoords['y'] = $objMap->wrapCoord($arrCoords['y'], $objMap->sizeY);
elseif ($objMap->sizeY) $arrCoords['y'] = max(0,min($objMap->sizeY-1,$arrCoords['y']));
@$arrCoords['x'] += $x;
if ($objMap->wrapX) $arrCoords['x'] = $objMap->wrapCoord($arrCoords['x'], $objMap->sizeX);
elseif ($objMap->sizeX) $arrCoords['x'] = max(0,min($objMap->sizeX-1,$arrCoords['x']));

$locId = $objMap->getId($arrCoords['z'],$arrCoords['y'],$arrCoords['x'],$objChar->loc['map']);

if ($locId === false) {
	$arrCoords = array('z'=>0, 'y'=>0, 'x'=>0);
	$locId = $objMap->getId(0,0,0,$objChar->loc['map']);
}



if ($locId > 0) {

	if ($_SESSION['PHPRPG']['UserLevel'] <= PHPRPG_AUTH_NONE) {

		if ($objChar->stm['cur'] < 1) {
			echo "alert('You are too tired and can not move!');";
			return;
		}

		if      ($x ==  0 && $y == -1) $direction = 'dn';
		else if ($x ==  1 && $y == -1) $direction = 'ne';
		else if ($x ==  1 && $y ==  0) $direction = 'de';
		else if ($x ==  1 && $y ==  1) $direction = 'se';
		else if ($x ==  0 && $y ==  1) $direction = 'ds';
		else if ($x == -1 && $y ==  1) $direction = 'sw';
		else if ($x == -1 && $y ==  0) $direction = 'dw';
		else if ($x == -1 && $y == -1) $direction = 'nw';

		$locObj = new LOCATION($objChar->loc['loc'],$objChar->loc['map']);
		if (empty($locObj->altTile)) {
			 $tileObj = new TILE($locObj->priTile);
		}
		else $tileObj = new TILE($locObj->altTile);

		if ($objChar->stm['cur'] < $tileObj->cost[$direction])
		{
			echo "alert('You are too tired and can not move!');";
			return;
		}

		$objChar->stm['cur'] = ($objChar->stm['cur'] - $tileObj->cost[$direction]);
	}

	$objChar->loc['loc'] = intval($locId);
	$objChar->save();
	$rebuildArgs  = $arrCoords['x'].','.$arrCoords['y'].',';
	$rebuildArgs .= $objMap->sizeX.','.$objMap->sizeY.',';
	$rebuildArgs .= $objMap->wrapX.','.$objMap->wrapY;
	echo 'rebuildMap('.$rebuildArgs.');';
}

echo "loadScript(\"".PHPRPG_URL."/bin/load-players.js.php\");";
echo "loadScript(\"".PHPRPG_URL."/bin/load-dropped-items.js.php\");";
echo "loadScript(\"".PHPRPG_URL."/bin/load-qstats.js.php\");";


?>