<?php
// Do standard require_onces
require_once('../../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/terrain.lib.php');

// Check if user has logged in and is an admin
$authObj = new AUTHENTICATE();
$authObj->login(PHPRPG_AUTH_TILE);

header('Content-type: text/javascript');

$tile_id = intval(@$_GET['tile-id']);

echo "\n clearTile();";

if ($tile_id < 1) exit();

$tileObj = new TILE($tile_id);
$tile_name = $tileObj->name;
$tile_override = $tileObj->override;
$tile_image_path = $tileObj->imagePath;
$tile_terrain = $tileObj->terrainId;

$tile_dn_cost = $tileObj->cost['dn'];
$tile_ne_cost = $tileObj->cost['ne'];
$tile_de_cost = $tileObj->cost['de'];
$tile_se_cost = $tileObj->cost['se'];
$tile_ds_cost = $tileObj->cost['ds'];
$tile_sw_cost = $tileObj->cost['sw'];
$tile_dw_cost = $tileObj->cost['dw'];
$tile_nw_cost = $tileObj->cost['nw'];

if ($tileObj->override) $tile_override = 'true';
else $tile_override = 'false';

if ($tile_dn_cost <  0) $tile_dn_cost = '-1';
if ($tile_dn_cost == 0) $tile_dn_cost = '';
if ($tile_ne_cost <  0) $tile_ne_cost = '-1';
if ($tile_ne_cost == 0) $tile_ne_cost = '';
if ($tile_de_cost <  0) $tile_de_cost = '-1';
if ($tile_de_cost == 0) $tile_de_cost = '';
if ($tile_se_cost <  0) $tile_se_cost = '-1';
if ($tile_se_cost == 0) $tile_se_cost = '';
if ($tile_ds_cost <  0) $tile_ds_cost = '-1';
if ($tile_ds_cost == 0) $tile_ds_cost = '';
if ($tile_sw_cost <  0) $tile_sw_cost = '-1';
if ($tile_sw_cost == 0) $tile_sw_cost = '';
if ($tile_dw_cost <  0) $tile_dw_cost = '-1';
if ($tile_dw_cost == 0) $tile_dw_cost = '';
if ($tile_nw_cost <  0) $tile_nw_cost = '-1';
if ($tile_nw_cost == 0) $tile_nw_cost = '';

echo "\n setTile($tile_id);";

echo "\n oTileImage = document.getElementById('tile-display-image');";
echo "\n oTileImage.src = '".PHPRPG_URL."/$tile_image_path';";
echo "\n oTileDNCost = document.getElementById('tile-dn-cost');";
echo "\n oTileDNCost.value = '$tile_dn_cost';";
echo "\n oTileNECost = document.getElementById('tile-ne-cost');";
echo "\n oTileNECost.value = '$tile_ne_cost';";
echo "\n oTileDECost = document.getElementById('tile-de-cost');";
echo "\n oTileDECost.value = '$tile_de_cost';";
echo "\n oTileSECost = document.getElementById('tile-se-cost');";
echo "\n oTileSECost.value = '$tile_se_cost';";
echo "\n oTileDSCost = document.getElementById('tile-ds-cost');";
echo "\n oTileDSCost.value = '$tile_ds_cost';";
echo "\n oTileSWCost = document.getElementById('tile-sw-cost');";
echo "\n oTileSWCost.value = '$tile_sw_cost';";
echo "\n oTileDWCost = document.getElementById('tile-dw-cost');";
echo "\n oTileDWCost.value = '$tile_dw_cost';";
echo "\n oTileNWCost = document.getElementById('tile-nw-cost');";
echo "\n oTileNWCost.value = '$tile_nw_cost';";
echo "\n oTileName = document.getElementById('tile-name-input');";
echo "\n oTileName.value = '$tile_name';";
echo "\n oTileOverride = document.getElementById('tile-override-checkbox');";
echo "\n oTileOverride.checked = $tile_override;";

echo "\n if(oSelect = document.getElementById('tile-terrain-select')) {";
echo "\n 	oSelect.options.length = 1;";

$i = 1;

foreach (TERRAIN::unique($tile_terrain) as $value) {
	$id = $value['value'];
	$name = $value['name'];
	$selected = empty($value['selected']) ? 'false' : 'true';
	echo "\n oSelect.options[".$i++."] = new Option('$name','$id', $selected, $selected);";
}

echo "\n }";


?>