<?php
require_once('../../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');
require_once(PHPRPG_DIR.'/lib/auth.lib.php');

header('Content-type: text/javascript');

$defTileId = 0;
$defTilePath = '/share/images/default_tile.png';
$transTileId = 0;
$transTilePath = '/share/images/mask_trans.png';

$maskTruePath = '/share/images/mask_success.png';
$maskFalsePath = '/share/images/mask_error.png';

$objAuth = new AUTHENTICATE();

// Check if user has admin status
if (!$objAuth->levelCheck(PHPRPG_AUTH_MAP)) exit;

unset($objAuth);

// Check for a current location, or exit (this should be set when the map editor is loaded)
if (empty($_SESSION['PHPRPG']['admin_zyx'])) exit;

$arrCoord = $_SESSION['PHPRPG']['admin_zyx'];

$radZ = 0;
$radY = PHPRPG_EDIT_HEIGHT;
$radX = PHPRPG_EDIT_WIDTH;

$minY = $arrCoord['y']-$radY;
$maxY = $arrCoord['y']+$radY;
$minX = $arrCoord['x']-$radX;
$maxX = $arrCoord['x']+$radX;

$minY = -$radY;
$maxY = $radY;
$minX = -$radX;
$maxX = $radX;

$objMap = new MAP($_SESSION['PHPRPG']['admin_map']);
$arrLocs = $objMap->snapshot($arrCoord['z'],$arrCoord['y'],$arrCoord['x'],$radZ,$radY,$radX);

// Only use the maps default tile if we have a fixed size map and are at z=0
// Otherwise, stick with the default-default tile (blank)
if($objMap->sizeX > 0 && $objMap->sizeY > 0 && $arrCoord['z'] == 0) {
	$defTileId = $objMap->defTile;
	$defTilePath = TILE::getImagePath($objMap->defTile);
}

$locZ = $arrCoord['z'];
for($y=$minY;$y<=$maxY;$y++) {
	for($x=$minX;$x<=$maxX;$x++) {
		$locY = $y+$arrCoord['y'];
		$locX = $x+$arrCoord['x'];
		$trans = 0;
		if($objMap->sizeZ > 0 && ($locZ < 0 || $locZ >= $objMap->sizeZ)) {
			if($objMap->wrapZ) {
				$locZ = $objMap->wrapCoord($locZ, $objMap->sizeZ);
			} else {
				$trans = 1;
			}
		}
		if($objMap->sizeY > 0 && ($locY < 0 || $locY >= $objMap->sizeY)) {
			if($objMap->wrapY) {
				$locY = $objMap->wrapCoord($locY, $objMap->sizeY);
			} else {
				$trans = 1;
			}
		}
		if($objMap->sizeX > 0 && ($locX < 0 || $locX >= $objMap->sizeX)) {
			if($objMap->wrapX) {
				$locX = $objMap->wrapCoord($locX, $objMap->sizeX);
			} else {
				$trans = 1;
			}
		}
		if(is_array(@$arrLocs["$locZ"]["$locY"]["$locX"])) {
			$tileId = @$arrLocs["$locZ"]["$locY"]["$locX"]['tile'];
			$image = @$arrLocs["$locZ"]["$locY"]["$locX"]['image'];
			$image[2] = $maskTruePath;
		} else {
			if($trans) {
				$tileId = $transTileId;
				$image = array($transTilePath, $transTilePath, $transTilePath);
				// No tile exists - no move
			} else {
				$tileId = $defTileId;
				$image = array($defTilePath, $transTilePath, $maskTruePath);
			}
		}
		if(!@$image[1]) $image[1] = $transTilePath; // Alt image
		if(!@$image[2]) $image[2] = $transTilePath; // Move mask
		echo '
		updateLoc('.$locX.', '.$locY.', "'.$image[0].'", "'.$image[1].'", "'.$image[2].'");';
	}
}


?>