<?php
require_once('../../../etc/runtime.conf.php');
require_once(PHPRPG_DIR.'/lib/map.lib.php');
require_once(PHPRPG_DIR.'/lib/tile.lib.php');
require_once(PHPRPG_DIR.'/lib/character.lib.php');

header('Content-type: text/javascript');

if (empty($_SESSION['PHPRPG']['admin_map']) || empty($_SESSION['PHPRPG']['admin_zyx'])) {
	$objChar = new CHARACTER($_SESSION['PHPRPG']['CharId'], PHPRPG_CHAR_CORE);
	$_SESSION['PHPRPG']['admin_map'] = $objChar->loc['map'];
	$_SESSION['PHPRPG']['admin_zyx'] = MAP::getCoords($objChar->loc['loc'],$_SESSION['PHPRPG']['admin_map']);
	unset($objChar);
}

$id = intval(@$_GET['id']);
$objMap = new MAP();
if(!is_array($_SESSION['PHPRPG']['admin_zyx'])) $_SESSION['PHPRPG']['admin_zyx'] = array('x' => 0, 'y' => 0, 'z' => 0);
$arrCoords = $_SESSION['PHPRPG']['admin_zyx'];

if ($id < 0) { // "New map" or error - don't load anything

	exit;

} elseif ($id == 0) { // Load current map

	$id = $_SESSION['PHPRPG']['admin_map'];
	$objMap->load($id);

} else { // Load new map

	$objMap->load($id);

	// See if current coords exist in the new map, or use (0,0,0)
	$locId = $objMap->getId($arrCoords['z'],$arrCoords['y'],$arrCoords['x']);
	if ($locId === false) {
		$arrCoords = array('z'=>0, 'y'=>0, 'x'=>0);
		$_SESSION['PHPRPG']['admin_zyx'] = $arrCoords;
	}

	$_SESSION['PHPRPG']['admin_map'] = $id;

}

$detailArgs	= '"'.htmlspecialchars($objMap->name).'"'
		. ','.$objMap->defTile
		. ',"'.TILE::getImagePath($objMap->defTile).'"'
		. ','.$objMap->sizeX
		. ','.$objMap->sizeY
		. ','.$objMap->sizeZ
		. ','.$objMap->wrapX
		. ','.$objMap->wrapY
		. ','.$objMap->wrapZ;

$rebuildArgs  = $arrCoords['x'].','.$arrCoords['y'].',';
$rebuildArgs .= $objMap->sizeX.','.$objMap->sizeY.',';
$rebuildArgs .= $objMap->wrapX.','.$objMap->wrapY;

unset($objMap);
?>
showMapDetails(<?php echo $detailArgs;?>);
rebuildMap(<?php echo $rebuildArgs;?>);
refreshMap();
