    /**
     * Constructor. Holds the default values.
     * @param tagName the tag name
     * @param className the class name
     **/
    function HoveredLink( tagName, className )
    {
        this.m_TagName = tagName;
        this.m_ClassName = className;
        this.m_Color = '#D0D000';
        this.m_BackgroundColor = '#0000A0';
        this.m_HoverClassName = null;

        this.m_Element = null;
        this.m_HoveredLinks = new Array();

        this.setColor = HoveredLink_setColor;
        this.getColor = HoveredLink_getColor;
        this.setBackgroundColor = HoveredLink_setBackgroundColor;
        this.getBackgroundColor = HoveredLink_getBackgroundColor;
        this.setHoverClassName = HoveredLink_setHoverClassName;
        this.getHoverClassName = HoveredLink_getHoverClassName;
        this.getElement = HoveredLink_getElement;
        this.create = HoveredLink_create;
        this.createForElement = HoveredLink_createForElement;
        this.revalidate = HoveredLink_revalidate;
        this.findLink = HoveredLink_findLink;
    }

    /**
     * Sets the font color of the hover effect.
     * @param color the font color
     */
    function HoveredLink_setColor( color )
    {
        this.m_Color = color;
    }

    /**
     * Returns the font color of the hover effect.
     * @return the font color
     */
    function HoveredLink_getColor( color )
    {
        return this.m_Color;
    }

    /**
     * Sets the background color of the hover effect.
     * @param color the background color
     */
    function HoveredLink_setBackgroundColor( color )
    {
        this.m_BackgroundColor = color;
    }

    /**
     * Returns the background color of the hover effect.
     * @return the background color
     */
    function HoveredLink_getBackgroundColor()
    {
        return this.m_BackgroundColor;
    }

    /**
     * Sets the class name of the hover effect.
     * @param className the class name
     */
    function HoveredLink_setHoverClassName( className )
    {
        this.m_HoverClassName = className;
    }

    /**
     * Returns the class name of the hover effect.
     * @return the class name
     */
    function HoveredLink_getHoverClassName()
    {
        return this.m_HoverClassName;
    }

    /**
     * Returns the html element for the hovered link.
     * @return the html element
     */
    function HoveredLink_getElement()
    {
        return this.m_Element;
    }

    /**
     * Creates a hovered link for all elements with the given tag name and class name.
     */
    function HoveredLink_create()
    {
        var elements = document.getElementsByTagName( this.m_TagName );
        var i;

        for ( i=0; i < elements.length; i++ )
        {
            if ( elements[i].className == this.m_ClassName && !elements[i].isHovered )
            {
                this.createForElement( elements[i] );
            }
            else if ( elements[i].className == this.m_ClassName && elements[i].isHovered )
            {
                this.revalidate( elements[i] );
            }
        }
    }

    /**
     * Creates a hovered link for a specific element.
     * @param element the element
     */
    function HoveredLink_createForElement( element )
    {
        var hleft = getAbsoluteLeft( element );
        var htop = getAbsoluteTop( element );
        var hwidth = element.offsetWidth;
        var hheight = element.offsetHeight;
        var existingLink = this.findLink( element );
        var href = existingLink.href;
        var target = existingLink.target;

        this.m_Element = document.createElement( 'DIV' );
        with ( this.m_Element.style )
        {
            position = 'absolute';
            left = hleft;
            top = htop;
            width = hwidth;
            height = hheight;
            zIndex = 3;
        }

        var hoverLink = document.createElement( 'A' );
        hoverLink.parentLink = existingLink;
        existingLink.childLink = hoverLink;
        existingLink.hoverContainer = this.m_Element;
        hoverLink.href = href;
        hoverLink.target = target;
        hoverLink.appendChild( createSpacer( hwidth, hheight ) );
        hoverLink.hover = element;
        element.isHovered = true;
        hoverLink.hovercolor = this.getColor();
        hoverLink.hoverbgcolor = this.getBackgroundColor();
        hoverLink.hoverclassname = this.getHoverClassName();
        if ( existingLink.onclick )
        {
            hoverLink.onclick = function()
            {
                this.parentLink.onclick();
            }
        }
        if ( existingLink.onfocus )
        {
            hoverLink.onfocus = function()
            {
                this.parentLink.onfocus();
            }
        }
        hoverLink.onmouseover = function()
        {
            this.oldcolor = this.parentLink.style.color;
            if ( this.hovercolor )
            {
                this.parentLink.style.color = this.hovercolor;
            }
            if ( this.hoverbgcolor )
            {
                this.hover.style.backgroundColor = this.hoverbgcolor;
            }
            this.oldclassname = this.className;
            if ( this.hoverclassname )
            {
                this.className = this.hoverclassname;
            }
            if ( this.parentLink.onmouseover )
            {
                this.parentLink.onmouseover();
            }
        };
        hoverLink.onmouseout = function()
        {
            this.parentLink.style.color = this.oldcolor;
            this.hover.style.backgroundColor = 'transparent';
            this.className = this.oldclassname;
            if ( this.parentLink.onmouseout )
            {
                this.parentLink.onmouseout();
            }
        };

        this.m_Element.appendChild( hoverLink );
        document.body.appendChild( this.m_Element );

        this.m_HoveredLinks[this.m_HoveredLinks.length] = element;
    }

    /**
     * Revalidates / repositions the hovered link.
     * @param element the parent element
     */
    function HoveredLink_revalidate( element )
    {
        var hleft = getAbsoluteLeft( element );
        var htop = getAbsoluteTop( element );
        var hwidth = element.offsetWidth;
        var hheight = element.offsetHeight;
        var existingLink = this.findLink( element );

        with ( existingLink.hoverContainer.style )
        {
            left = hleft;
            top = htop;
            width = hwidth;
            height = hheight;
        }
    }

    /**
     * Searches in an element for a link.
     * @param the element
     * @return the link
     */
    function HoveredLink_findLink( element )
    {
        if ( element.tagName == 'A' )
        {
            return element;
        }

        var i, link;
        for ( i=0; i < element.childNodes.length; i++ )
        {
            link = this.findLink( element.childNodes[i] );
            if ( link != null )
            {
                return link;
            }
        }

        return null;
    }