
/* Version 08.10.05 */



var clientId = 1005;

var praxisHostArr = new Array('www.sportscheck.de','www.sport-scheck.de','ww2.sportscheck.com','www.sportscheck.com');

var testHost = "yala.otto.de";

var testHostSslEnabled = 0;

var trace_mode = 0;


function getLMServletHost() {
	var host = location.hostname;
	var protocol = "http://";
	var praxisHosts = praxisHostArr.join(" ") + " ";
	if ( praxisHosts.toUpperCase().indexOf( host.toUpperCase() + " " ) > -1 ) {
		if ( location.protocol.toUpperCase().indexOf( "HTTPS" ) > -1 ) 
			protocol = "https://";
	} else {	
		host = testHost;
		if ( testHostSslEnabled == 1 ) 
			if ( location.protocol.toUpperCase().indexOf( "HTTPS" ) > -1 ) 
				protocol = "https://";
	}
	return protocol + host;
}

function hasSid( URL ) {
  var startTag = ";sid=";
  var pos = URL.indexOf( startTag );
  return ( pos > -1 )
}
  
function getSessionIdFromUrl( URL ) {
  var startTag = ";sid=";
  var pos = URL.indexOf( startTag );
  if ( pos != -1 ) URL = URL.substring( pos + startTag.length );
  pos = URL.indexOf( "?" );
  if ( pos != -1 ) URL = URL.substring( 0, pos );
  URL = URL.replace( /=/g, '' );
  return URL;
}

function getSessionId( URL ) {
  if ( hasSid( URL ) )
  	return getSessionIdFromUrl( URL );
  if( document.links ) {
    var found = 0;
    var i = 0;
	var sid = "";
    while( i<document.links.length && found == 0 ) {
      if( hasSid( document.links[ i ].href ) ) {
        sid = getSessionIdFromUrl( document.links[ i ].href );
        found = 1;
      }
	  i++;
	}
	return sid;
  }	
}	


function getArtNoFromProdRef( prodRef ) {
  var artNo = "";
  var arr = prodRef.split( /@/ );
  if ( arr[2] ) {
    var arr2 = arr[2].split( /-/ );
    if ( arr2[0] ) artNo = arr2[0];
  }  
  return artNo;
}


function getStatCookie( name ) {
   name += "=";
   var len = name.length;
   var cookie_len = document.cookie.length;
   var i = 0;
   while ( i < cookie_len ) {
     var j = i + len;
	 if ( document.cookie.substring(i,j) == name ) return getStatCookieValue(j);
	 i = document.cookie.indexOf( " ", i ) + 1;
	 if ( i == 0 ) break;
   }
   return null;
}

function getStatCookieValue( position ) {
   var end = document.cookie.indexOf(";", position );
   if ( end == -1 ) end = document.cookie.length;
   return unescape( document.cookie.substring( position, end ) );
}

function setStatCookie(name, value, expires, path) {
   var exp = new Date();
   exp.setTime(exp.getTime() + expires);
   document.cookie = name + "=" + value + "; expires=" + exp.toGMTString() +
	     ((path == null ) ? "" : ("; path=" + path ));
}

function setStatTempCookie(name, value, path) {
	document.cookie = name + "=" + value + ((path == null ) ? "" : ("; path=" + path ));
}

function getReferrer() {
	var attr = "";
	var wkReferrer = getStatCookie( "wkReferrer" );
	if ( wkReferrer != null && wkReferrer != "" ) {
		if ( wkReferrer.indexOf( location.hostname ) == -1 ) {
			attr = "&setWkReferrer=" + escape( wkReferrer );
		}	
		setStatTempCookie( "wkReferrer", "", "/" );
	}	
	return attr;	
}

function getLocationSearchImas() {
  var uebergabe=location.search.substring(1,location.search.length);
  uebergabe=unescape(uebergabe);
  var angabenTemp=uebergabe.split("&");
  var angaben=new Array();
  for(z in angabenTemp) {
	var paar=angabenTemp[z].split("=");
	// assoziatives Arrayfeld bilden
	angaben[paar[0]]=paar[1];
  }
  return angaben;
  // access values with angaben[<AttributeName>]
}

function getPromo() {
	var attr = "";
	// get it from anchor
	var hash = location.hash;
	if ( hash.indexOf( "lmPromo" ) > -1 ) {
    	var arr = hash.split( /=/ );
    	if ( arr.length > 1 ) 
    		attr = "&lmPromo=" + escape( arr[1] );
	}
	// get it from parameter
	if ( attr == "" ) {
		var pars = getLocationSearchImas();
		try {
			var lmPromo = pars[ "lmPromo" ];
			if ( lmPromo )
				attr = "&lmPromo=" + escape( lmPromo );
		} catch(e) {
		}	
	}
	return attr;
}


var LMArrLen = 10;
var LMimg = new Array(LMArrLen);
var LMArrPos = 0;

function setLandmarkWithSession( sessionId, landmark, attributes ) {
  var sessionId = clientId + getSessionId( sessionId );
  LMimg[ LMArrPos ] = new Image();
  var URL = getLMServletHost() + "/servlet/LandmarkServlet?clientId=" + clientId + 
                        "&landmark=" + landmark +
                        "&ssid=" + sessionId;
  if ( attributes ) URL = URL + attributes;  
  URL = URL + getReferrer();                      
  URL = URL + getPromo();
  LMimg[ LMArrPos++ ].src = URL;     
  if ( LMArrPos == LMArrLen ) LMArrPos = 0;
  if ( trace_mode != 0 ) alert( "Lm set: " + URL );
}

function setLandmark( landmark, attributes ) {
  // var sessionId = getSessionIdFromUrl( location.href );
  setLandmarkWithSession( location.href, landmark, attributes );
}




var mp_landmark = "";
var mp_attributes = "";
var mp_sessionId = "";
var mp_descriptions = ""; // special var for LM special basket, description will be omitted in case of more than 10 basket entries to avoid too long urls
var mp_count = 0;         // counts number of items in basket 

function startLandmark( landmark ) {
  mp_sessionId = location.href;
  mp_attributes = "";
  mp_descriptions = "";
  mp_count = 0;
  mp_landmark = landmark;
}

function addBasketStatus( status ) {
  var attributes = "&status=";
  if ( status == "5" ) attributes += "BB"; 
  else
    if ( status == "4" ) attributes += "LE"; 
    else attributes += "AN"; 
  addAttribute( attributes );
}

function addAttribute( attribute ) {
  if ( attribute.indexOf( "&" ) != 0 ) attribute = "&" + attribute;
  mp_attributes = mp_attributes + attribute;
}

function addArtDescription( description ) {
  if ( description.indexOf( "&" ) != 0 ) description = "&" + description;
  mp_descriptions = mp_descriptions + description;
  mp_count += 1;
}

function setSessionId( sessionId ) {
  mp_sessionId = sessionId;
}

function setMPLandmark() {
  if ( mp_count <= 10 ) mp_attributes += mp_descriptions;
  setLandmarkWithSession( mp_sessionId, mp_landmark, mp_attributes );
}  



function redirectLandmarkGeneralWithSession( sessionId, landmark, attributes, redirectURL, mitHistory ) {
  var URL = getLMServletHost() + "/servlet/LandmarkServlet?clientId=" + clientId + 
                        "&landmark=" + landmark +
                        "&ssid=" + clientId + sessionId +
			"&redirectUrl=" + escape( redirectURL );
  if ( attributes ) URL = URL + attributes;       
  if ( trace_mode != 0 ) alert( "Lm set: " + URL );
  if ( mitHistory != 0 ) window.document.location.href = URL;
  else 			 window.document.location.replace( URL );
}

function redirectLandmarkGeneral( landmark, attributes, redirectURL, mitHistory ) {
  var sessionId = getSessionId( redirectURL );
  redirectLandmarkGeneralWithSession( sessionId, landmark, attributes, redirectURL, mitHistory );
}


function redirectLandmark( landmark, attributes, redirectURL ) {
  redirectLandmarkGeneral( landmark, attributes, redirectURL, 1 );
}

function redirectLandmarkNoHistory( landmark, attributes, redirectURL ) {
  redirectLandmarkGeneral( landmark, attributes, redirectURL, 0 );
}
 
function redirectLandmarkWithSession( sessionId, landmark, attributes, redirectURL ) {
  redirectLandmarkGeneralWithSession( getSessionId( sessionId ), landmark, attributes, redirectURL, 1 );
}

function redirectLandmarkNoHistoryWithSession( sessionId, landmark, attributes, redirectURL ) {
  redirectLandmarkGeneralWithSession( getSessionId( sessionId ), landmark, attributes, redirectURL, 0 );
}

