"""
Uses the http://www.easysw.com/htmldoc/ bin to do its handy work

"""
from Products.PortalTransforms.interfaces import itransform
from Products.PortalTransforms.libtransforms.utils import bin_search, sansext
from Products.PortalTransforms.libtransforms.commandtransform import commandtransform
#from Products.PortalTransforms.libtransforms.commandtransform import popentransform
from Products.CMFDefault.utils import bodyfinder
import os
from os.path import join, abspath, dirname, basename
from os import system
from Products.CMFCore.utils import getToolByName
from popen2 import popen2
from Products.Plone2Pdf.config import DEBUG

class html_to_pdf(commandtransform):
    __implements__ = itransform
    
    __version__ = '2005-04-04.01'

    __name__ = "html_to_pdf"
    inputs   = ('text/html',)
    output  = 'application/pdf'
    output_encoding = 'utf-8'

    binaryName = "htmldoc"
    binaryArgs = " --quiet --header \"   \" --footer \" : \" --webpage -t pdf %(charset_opt)s --jpeg --linkcolor blue --linkstyle plain "
    useStdin = False

    def __init__(self):
        commandtransform.__init__(self, binary=self.binaryName)

    def convert(self, data, cache, **kwargs):
        if kwargs.get('charset', None):
            charset_opt = '--charset %s' %kwargs.get('charset')
        else:
            charset_opt = ''
        htmldoc_opts = kwargs.get('htmldoc_opts', None)
        htmldoc_opts_override = kwargs.get('htmldoc_opts_override', None)
        pdf = self.invokeCommand(data, charset_opt,htmldoc_opts,htmldoc_opts_override)
        cache.setData(pdf)
        return cache

    def invokeCommand(self, data, charset_opt,htmldoc_opts,htmldoc_opts_override):
        if htmldoc_opts_override:
            argsToPass = ' ' + htmldoc_opts
        else:            
            if htmldoc_opts:        
                argsToPass = ' ' + htmldoc_opts + ' ' + self.binaryArgs %{'charset_opt':charset_opt}
            else:
                argsToPass = self.binaryArgs %{'charset_opt':charset_opt}
                
        #print data.absolute_url()
        try:
            import tempfile
            f, fn = tempfile.mkstemp()
            
            # Write page in a temporary file
            os.close(f)
            f = open(fn, "w")
            f.write(data.viewPdf())
            #raise data.viewPdf()
            f.close()
            f2,fn2 = tempfile.mkstemp()
            os.close(f2)
            
            binCmd = self.binary + argsToPass + " -f " + fn2 + " " + fn
            #binCmd = self.binary + argsToPass + data.absolute_url()+'/viewPdf'
            
            outfile, infile = popen2(binCmd, mode='b')
            #infile.write(data)
            infile.write('')
            infile.flush()
            infile.close()
            outfile.close()
            os.system("sync")

            outfile = open(fn2,"r")
            pdf = outfile.read()
            outfile.close()
        except Exception,e:
            # Delete attachment file
            if os.path.isfile(fn):
                os.unlink(fn)
            if os.path.isfile(fn2):
                os.unlink(fn2)
            if DEBUG: raise e
            return ''

        # Delete attachment file
        if os.path.isfile(fn2):
            os.unlink(fn2)
        if os.path.isfile(fn):
            os.unlink(fn)
        return pdf


def register():
    return html_to_pdf()
