#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
"""
# filename: externRandom.py
# version   : 0.12
# author    : T.Hinze (HiDeVis)
# date      : 23.02.2006
#
# parameters
#   text                - text der geprft wird
#   typeID              - legt fest, auf was geprft wird
#
#
# return value : 
#   dict {              - Ergebnis der RegExp-Prfung
#       'status'        - True oder False
#       'error'         - wenn Fehler findet hier eine Beschreibung
#
###########################################################
# Dokumentation
# -------------
# 
# Als Rckgabewert wird ein Dictonary geliefert. {'status': '', 'error': ''}
# Im Status wird festgehalten, ob der Vergleich erfolgreich (0), fehlgeschlagen (1) oder ob 
# beim Vorgang Fehler (-1) aufgetreten sind. In 'msg' kann dann die entsprechende Statusmeldung
# ausgelesen werden.
#
###########################################################
"""

#---------
# imports
#---------
from random import seed, random, randrange, choice, shuffle 

def extern_random(command, arg):
    if command == 'seed':
        seed()
        return True

    if command == 'random':
        if arg is None:
            return random()
        else:
            return randrange(arg)
        
    if command == 'choice':
        return choice(arg)

    if command == 'shuffle':
        tmp = arg[:]
        shuffle(tmp)
        return tmp
        
    # unknown command
    return arg
        
