"""
SimpleSkin 2005

"""
from Products.Archetypes.Extensions.utils import install_subskin
from Products.CMFCore.TypesTool import ContentFactoryMetadata
from Products.CMFCore.DirectoryView import addDirectoryViews
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import ManagePortal

from cStringIO import StringIO
import string

from Products.SimpleSkin.config import *


def setupSkin(self, out):
    skinsTool = getToolByName(self, 'portal_skins')

    # Add directory views
    addDirectoryViews(skinsTool, 'skins', GLOBALS)
    out.write("Added directory views to portal_skins.\n")
    
    # Insert the skin in the skin configuration.
    if SKIN_NAME not in skinsTool.getSkinSelections():
        # Get the skin paths of the base skin and convert to an array.
        path = skinsTool.getSkinPath(BASE_SKIN)
        path = map(string.strip, string.split(path,','))

        install_subskin(self, out, GLOBALS)
            
        # Add your skin.
        path = string.join(path, ', ')
        skinsTool.addSkinSelection(SKIN_NAME, path)
        out.write("Added skin.\n")

        # Activate your skin
        skinsTool.manage_properties(default_skin=SKIN_NAME)
        out.write("Activated skin.\n")
    else:
        out.write('Skin already exists, leaving it alone.\n')
#----------------------------

def install(self):
    out=StringIO()
    
    #-----------------------------------------------
    # install SimpleSkinProperties to portal_properties
    #-----------------------------------------------
    self.portal_properties = getToolByName(self, 'portal_properties')
    if not hasattr(self.portal_properties, 'simpleskin_properties'):
      self.portal_properties.addPropertySheet('simpleskin_properties', 'SimpleSkin Properties')
    
    registerStylesheets(self, out)
    registerJavascripts(self, out)
    registerExternalMethods(self, out)
    
    props = self.portal_properties.simpleskin_properties
    
    if not hasattr(props, 'example_attr1'):
      props._setProperty('example_attr1', '1', 'string')
      
    #----------------------------------------
    # install portal_actions['site_actions']
    #----------------------------------------
    actions       = getToolByName(self, 'portal_actions')
    allActions    = actions.listFilteredActionsFor(self)
    valueList     = []
    
    #---------------------------------------------
    # deactivate all existing site_actions
    #---------------------------------------------
    if 'site_actions' in allActions:
      siteActions   = allActions['site_actions']
      # list of values of site_actions
      for action in siteActions:
        valueList.extend(action.values())  
              
      # code cooming soon...  
          
    else:      
      #-----------------------
      # install 'login'
      #-----------------------
      if not 'login' in valueList:
        actions.addAction('login', 'Login', 'string:${object_url}/login_form', '', 'View', 'site_actions', True)
        out.write("'login' added to site_actions\n")
      else:
        out.write("'login' also added at site_actions (no change)\n")
      #-----------------------
      # install 'small_text'
      #-----------------------
      if not 'small_text' in valueList:
        actions.addAction('small_text', 'Text klein', 'string:javascript:setActiveStyleSheet("Small Text", 1);', '', 'View', 'site_actions', True)
        out.write("'small_text' added to site_actions\n")
      else:
        out.write("'small_text' also added at site_actions (no change)\n")
      #-----------------------
      # install 'normal_text'
      #-----------------------
      if not 'normal_text' in valueList:
        actions.addAction('normal_text', 'Text normal', 'string:javascript:setActiveStyleSheet("", 1);', '', 'View', 'site_actions', True)
        out.write("'normal_text' added to site_actions\n")
      else:
        out.write("'normal_text' also added at site_actions (no change)\n")
      #-----------------------
      # install 'large_text'
      #-----------------------
      if not 'large_text' in valueList:
        actions.addAction('large_text', 'Text gross', 'string:javascript:setActiveStyleSheet("Large Text", 1);', '', 'View', 'site_actions', True)
        out.write("'large_text' added to site_actions\n")
      else:
        out.write("'large_text' also added at site_actions (no change)\n")
    
    # current version info: disable some actions by hand
    out.write("*** You have to deactivate the existing site_actions \n'sidemap', 'accessibility' and 'contact'!\n")  
    
    #--------------------------------------   

    setupSkin(self, out)
    out.write('Installation completed.\n')
    return out.getvalue()
#----------------------------

def uninstall (self):
    out = StringIO ()

    removeSkin (self, out)
    
    unregisterStylesheets(self, out)
    unregisterJavascripts(self, out)
    unregisterExternalMethods(self, out)

    out.write ('Uninstallation completed.\n')
    return out.getvalue()
#----------------------------

def removeSkin(self, out):
    skinsTool = getToolByName(self, 'portal_skins')

    # Delete the property which holds the skin.
    if SKIN_NAME in skinsTool.getSkinSelections():
        skinsTool.manage_skinLayers(del_skin = 1, chosen = (SKIN_NAME,))
    skinsTool.manage_properties(default_skin=BASE_SKIN)
    out.write('Removed skin.\n')
#----------------------------

def registerStylesheets(self, out):
    """ register CSS stylesheets in portal_css """
    if STYLESHEETS is not None:
        cssTool = getToolByName(self, 'portal_css')
        for css in STYLESHEETS:
            cssTool.registerStylesheet(**css)
    
        out.write('Stylesheet(s) in portal_css registered \n')
#----------------------------

def unregisterStylesheets(self, out):
    """ unregister stylesheets in portal_css """
    if STYLESHEETS is not None:
        cssTool=getToolByName(self, 'portal_css')
        sheetnames = [ css['id'] for css in STYLESHEETS ]
        for sheetname in sheetnames:
            cssTool.unregisterResource(sheetname)
    
        out.write('Unregistered stylesheet(s) in portal_css. \n')
#----------------------------

def registerJavascripts(self, out):
    """ register Javascripts in portal_javascripts """
    if JAVASCRIPTS is not None:
        jsTool = getToolByName(self, 'portal_javascripts')
        for js in JAVASCRIPTS:
            jsTool.registerScript(**js)
    
        out.write('Javascript(s) in portal_javascripts registered \n')
#----------------------------

def unregisterJavascripts(self, out):
    """ unregister javascripts in portal_javscripts """
    if JAVASCRIPTS is not None:
        jsTool = getToolByName(self, 'portal_javascripts')
        javascriptnames = [ js['id'] for js in JAVASCRIPTS ]
        for javascriptname in javascriptnames:
            jsTool.unregisterResource(javascriptname)
    
        out.write('Unregistered javascript(s) in portal_javascript. \n')
#----------------------------

def registerExternalMethods(self, out):
    """ register external methods """
    if EXTERNAL_METHODS is not None:
        installedIDs    = []            # list of installed ext. method IDs
        for extMethod in EXTERNAL_METHODS:
            try:
                if not hasattr(self, extMethod['id']):
                    self.manage_addProduct['ExternalMethod'].manage_addExternalMethod(**extMethod)
                    installedIDs.append(extMethod['function'])
                else:
                    out.write('Ext. method "' + extMethod['id'] + '" already exists \n')
                    
            except:
                raise AssertionError('the external method called "' + extMethod['id'] + '" was not found.')
    
    if len(installedIDs):
        out.write(str(len(installedIDs)) + ' External Methods registered \n')
    
#----------------------------

def unregisterExternalMethods(self, out):
    """ unregister external methods """
    if EXTERNAL_METHODS is not None:
        removedIDs  = []                    # list of the removed ext. methods
        failedIDs   = []                    # list of failed IDs
        for extMethod in EXTERNAL_METHODS:            
            if hasattr(self, extMethod['id']):
                self.manage_delObjects(extMethod['id'])
                removedIDs.append(extMethod['id'])
    
            else:
                failedIDs.append(extMethod['id'])
                
        if len(failedIDs):          # some IDs failed
            out.write('>> Warning: External methods ' + str(failedIDs) + ' cant remove, because it doesn\'t exist \n')
    
        out.write(str(len(removedIDs)) + ' External Methods removed \n')
#----------------------------
