from Products.CMFCore import CMFCorePermissions
from AccessControl import getSecurityManager, ClassSecurityInfo
from Products.Archetypes.public import *
from Products.Archetypes.interfaces.orderedfolder import IOrderedFolder
from Products.ATContentTypes.atct import ATFolder, ATFolderSchema
from Products.FAQulator.config import *

schema  = ATFolderSchema.copy() + Schema((
        TextField("description",
            searchable = True,
            required   = True,
            accessor   = "Description",
            storage    = MetadataStorage(),
            widget     = VisualWidget(
                i18n_domain       = "faqulator",
                label             = "Description",
                label_msgid       = "faq_introlabel",
                description_msgid = "faq_intro",
                description       = "Text above the questions list")
                  ),
        BooleanField("show_header",
            searchable  = False,
            widget      = BooleanWidget(
                i18n_domain       = "faqulator",
                label             ="Show question list",
                label_msgid       ="faq_showheaderlabel",
                description_msgid ="faq_showheader",
                description       =
                        "Show a short list with all questions at the top of "
                        "the FAQ. This can make it navigation easier if you have "
                        "a large number of entries in your FAQ.")
            ),
        BooleanField("show_answers",
            searchable = False,
            default    = True,
            widget     = BooleanWidget(
                i18n_domain       = "faqulator",
                label             = "Show answers",
                label_msgid       = "faq_showanswerslabel",
                description_msgid = "faq_showanswers",
                description       =
                    "Show the individual questions and their answers in full. This "
                    "is standard behaviour for a FAQ.")
            ),
        
        ))


class FAQ(ATFolder):
    """A frequently asked questions list."""
    schema                      = schema
    content_icon                = "faq_icon.gif"
    filter_content_types        = True
    allowed_content_types       = ( "FAQEntry", )
    archetype_name          = "FAQ"
    default_view                = "faq_view"
    immediate_view              = "faq_view"
    suppl_views         = ( "folder_summary_view", "folder_tabular_view" )

    security            = ClassSecurityInfo()
    security.declarePublic("listFolderContents")

    actions     = (
            { 'id'              : "view",
              'name'            : "View",
              'action'          : "string:${object_url}/faq_view",
              'permissions'     : (CMFCorePermissions.View,)
                },
               )
        
    def post_validate(self, REQUEST=None, errors={}):
        """Custom validator to check if either show_header or show_ansers is set.
        """

        if not (int(REQUEST.form.get("show_header",1)) or int(REQUEST.form.get("show_answers",1))):
            errors["show_header"]="Please select one of the show question list or show answers options"


registerType(FAQ, PROJECTNAME)
