from Products.Archetypes.public import *
from Products.ATContentTypes.content.base import ATCTContent
from Products.ATContentTypes.content.schemata import ATContentTypeSchema
from Products.FAQulator.config import *

schema  = ATContentTypeSchema.copy() + Schema((
    TextField("answer",
        required                = True,
        searchable              = True,
        primary                 = True,
        allowable_content_types = ('text/html', 'text/plain'),
        default_content_type    = 'text/html',
        default_output_type     = 'text/html',
        widget                  = RichWidget(
            i18n_domain       = "faqulator",
            label             = "Answer",
            label_msgid       = "faq_answer_label",
            description_msgid ="faq_answer",
            description       = "The answer to the question.",
            )
    ),
    TextField("words",
        required                = False,
        searchable              = True,
        secondary               = True,
        allowable_content_types = ('text/html', 'text/plain'),
        default_content_type    = 'text/html',
        default_output_type     = 'text/html',
        widget                  = RichWidget(
            i18n_domain       = "faqulator",
            label             = "words",
            label_msgid       = "faq_words_label",
            description_msgid ="faq_words",
            description       = "The Searchwords to the question.",
            )
        ),
    )) 


schema['allowDiscussion'].schemata = 'default'
del schema["description"]

schema["title"].widget=StringWidget(
                i18n_domain       = "faqulator",
                label             = "Question",
                label_msgid       = "faq_question_label",
                description_msgid = "faq_question",
                description       = "A commonly asked question.")
schema.moveField("answer", after="title")
schema.moveField("words", after="answer")

class FAQEntry(ATCTContent):
    """A frequently asked question."""

    __implements__             = (ATCTContent.__implements__,)
    schema                     = schema
    global_allow               = False
    _at_rename_after_creation  = True
    archetype_name             = "Question"
    content_icon               = "faq_icon.gif"

    def getQuestion(self):
        return self.Title()


registerType(FAQEntry, PROJECTNAME)

