from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.CMFPlone.migrations.migration_util import safeEditProperty

from Products.newCT.config import *

from StringIO import StringIO

def install(self):
    out = StringIO()

    installTypes(self, out, listTypes(PRODUCT_NAME), PRODUCT_NAME)

    install_subskin(self, out, GLOBALS)
    
    # add this CT to viewable CT's in folder_contents
    siteProps = self.portal_properties.site_properties
    viewTypes = getattr(siteProps, 'typesUseViewActionInListings', None)
    if viewTypes is not None:
        viewTypes += ('ImagePlus',)
        safeEditProperty(siteProps, 'typesUseViewActionInListings', viewTypes, 'lines')
    
    out.write(PRODUCT_NAME + " successfully installed \n")
    return out.getvalue()


def uninstall(self):
    out = StringIO()
    
    # remove from viewable CT's in folder_contents
    siteProps = self.portal_properties.site_properties
    viewTypes = getattr(siteProps, 'typesUseViewActionInListings', None)
    if viewTypes is not None:
        if 'ImagePlus' in viewTypes:
            viewTypes = list(viewTypes)
            del viewTypes[viewTypes.index('ImagePlus')]  # remove this CT from list
            viewTypes = tuple(viewTypes)
            safeEditProperty(siteProps, 'typesUseViewActionInListings', viewTypes, 'lines')
    
    ##+ uninstallTypes(...)
    ##+ uninstallSubSkins(...)
    
    out.write(PRODUCT_NAME + ' was uninstalled \n')
    return out.getvalue()
    
