# File: Mitarbeiter.py
#
# Copyright (c) 2006 by []
# Generator: ArchGenXML Version 1.4.1
#            http://plone.org/products/archgenxml
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

__author__ = """unknown <unknown>"""
__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.mitarbeiter.config import *

##code-section module-header #fill in your manual code here
##/code-section module-header

schema = Schema((

    StringField(
        name='academictitle',
        widget=StringWidget(
            label_msgid="mitarbeiter_academictitel_label",
            label='Academictitle',
            i18n_domain='mitarbeiter',
        ),
        schemata="Person"
    ),

    StringField(
        name='vorname',
        widget=StringWidget(
            label_msgid="mitarbeiter_vorname_label",
            description="mitarbeiter_vorname_description",
            label='Vorname',
            description_msgid='mitarbeiter_help_vorname',
            i18n_domain='mitarbeiter',
        ),
        schemata="Person",
        searchable=True
    ),

    StringField(
        name='nachname',
        index="FieldIndex",
        widget=StringWidget(
            label_msgid="mitarbeiter_nachname_label",
            label='Nachname',
            i18n_domain='mitarbeiter',
        ),
        schemata="Person",
        searchable=True
    ),

    StringField(
        name='kuerzel',
        widget=StringWidget(
            label_msgid="mitarbeiter_kuerzel_label",
            label='Kuerzel',
            i18n_domain='mitarbeiter',
        ),
        schemata="Person"
    ),

    PhotoField(
        name='portrait',
        widget=FileWidget(
            label_msgid="mitarbeiter_portrait_label",
            label='Portrait',
            i18n_domain='mitarbeiter',
        ),
        schemata="Person",
        sizes={'thumb':(80,80),'medium':(200,2000),'large':(600,600)}
    ),

    StringField(
        name='hierarchie',
        index="FieldIndex",
        widget=SelectionWidget(
            label_msgid="mitarbeiter_hierarchie_label",
            label='Hierarchie',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation",
        searchable=True,
        vocabulary=('Mitarbeiter','Leiter','Stellvertreter'),
        default='Mitarbeiter'
    ),

    StringField(
        name='funktion',
        widget=StringWidget(
            label_msgid="mitarbeiter_funktion_label",
            label='Funktion',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation",
        searchable=True
    ),

    StringField(
        name='email',
        widget=StringWidget(
            label_msgid="mitarbeiter_email_label",
            label='Email',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation",
        validators=('isEmail',)
    ),

    StringField(
        name='telefonintern',
        widget=StringWidget(
            label_msgid="mitarbeiter_telefonintern_label",
            label='Telefonintern',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation"
    ),

    StringField(
        name='raumnr',
        widget=StringWidget(
            label_msgid="mitarbeiter_raumnr_label",
            label='Raumnr',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation"
    ),

    ReferenceField(
        name='abteilung',
        index="FieldIndex",
        widget=ReferenceWidget(
            label_msgid="mitarbeiter_abteilung_label",
            label='Abteilung',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation",
        multiValued=True,
        relationship='Abteilung',
        allowed_types='Abteilung'
    ),

    ReferenceField(
        name='studiengang',
        index="FieldIndex",
        widget=ReferenceWidget(
            label_msgid="mitarbeiter_studiengang_label",
            label='Studiengang',
            i18n_domain='mitarbeiter',
        ),
        schemata="Organisation",
        multiValued=True,
        relationship='Studiengang',
        allowed_types='Studiengang'
    ),

    FileField(
        name='lebenslauf',
        schemata="Person",
        widget=FileWidget(
            label_msgid="mitarbeiter_lebenslauf_label",
            label='Lebenslauf',
            i18n_domain='mitarbeiter',
        ),
        storage=AttributeStorage()
    ),

    FileField(
        name='publikation',
        schemata="Person",
        widget=FileWidget(
            label_msgid="mitarbeiter_publikation_label",
            label='Publikation',
            i18n_domain='mitarbeiter',
        ),
        storage=AttributeStorage()
    ),

    TextField(
        name='info',
        allowable_content_types=('text/plain', 'text/structured', 'text/html', 'application/msword',),
        widget=RichWidget(
            label_msgid="mitarbeiter_info_label",
            label='Info',
            i18n_domain='mitarbeiter',
        ),
        default_output_type='text/html',
        schemata="Sonstige Informationen"
    ),

),
)

##code-section after-local-schema #fill in your manual code here
##/code-section after-local-schema

Mitarbeiter_schema = BaseSchema.copy() + \
    schema.copy()

##code-section after-schema #fill in your manual code here
##/code-section after-schema

class Mitarbeiter(BaseContent):
    """
    Einen neuen Mitarbeiter anlegen
    """
    security = ClassSecurityInfo()
    __implements__ = (getattr(BaseContent,'__implements__',()),)

    # This name appears in the 'add' box
    archetype_name = 'Mitarbeiter'

    meta_type = 'Mitarbeiter'
    portal_type = 'Mitarbeiter'
    allowed_content_types = []
    filter_content_types = 0
    global_allow = 0
    allow_discussion = False
    content_icon = 'mitarbeiter.png'
    immediate_view = 'mitarbeiter_detail'
    default_view = 'mitarbeiter_detail'
    suppl_views = ()
    typeDescription = "Mitarbeiter"
    typeDescMsgId = 'description_edit_mitarbeiter'

    actions =  (


       {'action': "string:${object_url}/mitarbeiter_detail",
        'category': "object",
        'id': 'view',
        'name': 'View',
        'permissions': ("View",),
        'condition': 'python:1'
       },


    )

    _at_rename_after_creation = True

    schema = Mitarbeiter_schema

    ##code-section class-header #fill in your manual code here
    ##/code-section class-header

    # Methods

registerType(Mitarbeiter,PROJECTNAME)
# end of class Mitarbeiter

##code-section module-footer #fill in your manual code here
##/code-section module-footer



