## Script (Python) "createAutoImagesJSCode_py"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=objList,portalProps=None,debug=None
##title=
"""
# version : 0.11
# author  : T.Hinze (HiDeVis)
# datum   : 23.05.2006 
# 
# parameter
#   objList             - list with image references or None
#
# return value 
#   string              - Javascript code with references to all founded images
#
###########################################################
# Documentation
# -------------
# 
# This script generates JS-code to preload the images references by
# the objList. The result in Javascript is an array with image objects
# that can be used with DTML-methods.
# Additionaly the small logic for automatic delayed picture change is
# also included in the return string.
#  
###########################################################
"""

#---------
# imports
#---------


#------
# init
#------
jsOut           = ''
if portalProps is None:
    portalProps = container.getPortalProps_py()

autoChangeDelay = portalProps.get('autochange_delay', 10000)    # delay in milliseconds

# create the JS code sequence
if objList:
    jsOut  += 'var allImages = new Array(); '
    idx     = 0
    for img in objList:
        jsOut += 'allImages[' + str(idx) + '] = new Image();'
        jsOut += 'allImages[' + str(idx) + '].src = "' + img.absolute_url() + '/image_mini"; '
        idx += 1

    jsOut += """
            /* the function to change the image source named 'autoChangeSideImage()' is
               defined in the skin-javascript file
            */
            var autoChangeDelay = """ + str(autoChangeDelay) + """;
            initAutoChange();
            
            """
#--------
# return
#--------
return jsOut
