from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.ATMediaPage.Extensions.utils import *
from Products.ATMediaPage.config import *
from Products.CMFDynamicViewFTI.migrate import migrateFTIs
from Products.CMFPlone.migrations.migration_util import safeEditProperty
from StringIO import StringIO

def install(self):
    out = StringIO()

    installTypes(self, out, listTypes(PROJECTNAME), PROJECTNAME)
    install_subskin(self, out, GLOBALS)
    registerStylesheets(self, out, STYLESHEETS)
    registerScripts(self, out, JAVASCRIPTS)

    # Migrate FTI, to make sure we get the necessary infrastructure for the
    # 'display' menu to work.
    migrated = migrateFTIs(self, product=PROJECTNAME)
    print >>out, "Switched to DynamicViewFTI: %s" % ', '.join(migrated)
                                    
    factory = getToolByName(self, 'portal_factory')
    types = factory.getFactoryTypes().keys()
    if 'MediaPage' not in types:
      types.append('MediaPage')
      factory.manage_setPortalFactoryTypes(listOfTypeIds = types)
      
          
    propsTool = getToolByName(self, 'portal_properties')
    siteProperties = getattr(propsTool, 'site_properties')
    navtreeProperties = getattr(propsTool, 'navtree_properties')        
      
    # set the default autochange_delay
    safeEditProperty(siteProperties, 'autochange_delay', AUTOCHANGE_DELAY, 'int')

    # Remove from use_folder_tabs
    useFolderTabs = list(siteProperties.getProperty('use_folder_tabs'))
    if 'MediaPage' in useFolderTabs:
        useFolderTabs.remove('MediaPage')
    siteProperties.manage_changeProperties(use_folder_tabs = useFolderTabs)

    # Remove from typesLinkToFolderContentsInFC 
    typesLinkToFolderContentsInFC = list(siteProperties.getProperty('typesLinkToFolderContentsInFC'))
    if 'MediaPage' in typesLinkToFolderContentsInFC:
        typesLinkToFolderContentsInFC.remove('MediaPage')
    siteProperties.manage_changeProperties(typesLinkToFolderContentsInFC = typesLinkToFolderContentsInFC)

    # Add to default_page_types
    defaultPageTypes = list(siteProperties.getProperty('default_page_types'))
    if 'MediaPage' not in defaultPageTypes:
        defaultPageTypes.append('MediaPage')
    siteProperties.manage_changeProperties(default_page_types = defaultPageTypes)

    # Add to parentMetaTypesNotToQuery
    parentMetaTypesNotToQuery = list(navtreeProperties.getProperty('parentMetaTypesNotToQuery'))
    if 'MediaPage' not in parentMetaTypesNotToQuery:
        parentMetaTypesNotToQuery.append('MediaPage')
    navtreeProperties.manage_changeProperties(parentMetaTypesNotToQuery = parentMetaTypesNotToQuery)
      

    
    out.write("Successfully installed %s. :-)" % PROJECTNAME)
  
    
    
    return out.getvalue()
