# ATMediaPage a new content type for easy creating Page with images.
# 
# Autor: Maik Derstappen - Derstappen IT <maik.derstappen@derstappen-it.de>
# License: see LICENSE.txt
#
"""

"""
__author__  = 'Maik Derstappen <maik.derstappen@derstappen-it.de>'
__docformat__ = 'restructuredtext'

from types import TupleType
try:
  from Products.LinguaPlone.public import *
except ImportError:
  #no multilingual support!
  from Products.Archetypes.public import *
from Products.CMFCore.CMFCorePermissions import View, ManageProperties
from Products.CMFCore.utils import getToolByName
from Products.ATContentTypes.content.document import ATDocument
from Products.ATContentTypes.content.document import finalizeATCTSchema
from Products.CMFPlone.interfaces.NonStructuralFolder import INonStructuralFolder

from Products.ATMediaPage.interfaces import IMediaPage
from Products.ATMediaPage.schemata.SMediaPage import SMediaPage
from config import PROJECTNAME, AUTOCHANGE_DELAY


class MediaPage(OrderedBaseFolder, ATDocument):
        """
        MediaPage is a Page which can contain ATImage objects.
        """
        schema = SMediaPage

        content_icon    = 'document_icon.gif'
        meta_type       = 'ATMediaPage'
        portal_type     = 'MediaPage'
        archetype_name  = 'MediaPage'
        default_view    = 'mediapage_view'
        immediate_view  = 'mediapage_view'
        suppl_views     = ('mediapage_view',
                           'mediapage_preview-right_view',
                           'mediapage_thumb-bottom_view',
                           'mediapage_images_autochange_view',
                           'mediapage_banner_view',
                           'mediapage_banner2_view')

        typeDescription= 'A portal page which can contain text and ATImages.'
        typeDescMsgId  = 'description_edit_mediapage'
        filter_content_types = 1
        global_allow = 1  # allow/disallow creation outside of Container
        allowed_content_types     = ('Image','ATImage')
        _at_rename_after_creation = True
        __implements__ = OrderedBaseFolder.__implements__ + ATDocument.__implements__
        actions = ATDocument.actions
        
        # ---  methods  ---
        
        def canSetDefaultPage(self):
            return False
        #--------------------
        
        # enable FTP/WebDAV and friends
        PUT = ATDocument.PUT
        

registerType(MediaPage, PROJECTNAME)


